/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.ExpressionDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class AddExpressionActionDelegate
extends AbstractEditorActionDelegate {
    public void run(IAction iAction) {
        String string = this.getSelectedText();
        ExpressionDialog expressionDialog = new ExpressionDialog(this.getShell(), string);
        if (expressionDialog.open() != 0) {
            return;
        }
        this.createExpression(expressionDialog.getExpression());
    }

    protected String getSelectedText() {
        ISelection iSelection = this.getTargetSelection();
        if (iSelection != null && iSelection instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getText().trim();
        }
        return "";
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private void createExpression(final String string) {
        Display display = CDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    IExpression iExpression = CDebugModel.createExpression((IDebugTarget)AddExpressionActionDelegate.this.getDebugTarget(), (String)string);
                    DebugPlugin.getDefault().getExpressionManager().addExpression(iExpression);
                    AddExpressionActionDelegate.this.showExpressionView();
                }
                catch (DebugException debugException) {
                    CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.AddExpressionActionDelegate.Evaluation_of_expression_failed"), debugException);
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        IDebugTarget iDebugTarget = null;
        if (iWorkbenchPart != null && iWorkbenchPart.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget iDebugTarget2;
            Object object;
            if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) != null && object instanceof IDebugElement && (iDebugTarget2 = ((IDebugElement)object).getDebugTarget()) != null && iDebugTarget2 instanceof ICExpressionEvaluator) {
                iDebugTarget = iDebugTarget2;
            }
            this.setDebugTarget(iDebugTarget);
            this.update();
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget iDebugTarget;
        this.setDebugTarget(null);
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable != null && iAdaptable instanceof IDebugElement && (iDebugTarget = ((IDebugElement)iAdaptable).getDebugTarget()) != null && iDebugTarget instanceof ICExpressionEvaluator) {
            this.setDebugTarget(iDebugTarget);
        }
    }

    protected void showExpressionView() {
        IWorkbenchPage iWorkbenchPage = CDebugUIPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.debug.ui.ExpressionView");
            if (iViewPart == null) {
                try {
                    iWorkbenchPage.showView("org.eclipse.debug.ui.ExpressionView");
                }
                catch (PartInitException partInitException) {
                    CDebugUIPlugin.log(partInitException.getStatus());
                }
            } else {
                iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
            }
        }
    }
}

