/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

public class SourcePropertyPage
extends PropertyPage {
    private SourceLookupBlock fBlock = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourcePropertyPage() {
        this.noDefaultAndApplyButton();
        this.fBlock = new SourceLookupBlock();
    }

    protected Control createContents(Composite composite) {
        ICDebugTarget iCDebugTarget = this.getDebugTarget();
        if (iCDebugTarget == null || iCDebugTarget.isTerminated() || iCDebugTarget.isDisconnected()) {
            return this.createTerminatedContents(composite);
        }
        return this.createActiveContents(composite);
    }

    protected Control createTerminatedContents(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(CDebugUIPlugin.getResourceString("ui.sourcelookup.SourcePropertyPage.Terminated"));
        return label;
    }

    protected Control createActiveContents(Composite composite) {
        this.fBlock.initialize(this.getLaunchConfiguration());
        this.fBlock.createControl(composite);
        return this.fBlock.getControl();
    }

    protected ICDebugTarget getDebugTarget() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICDebugTarget)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean performOk() {
        if (this.fBlock.isDirty()) {
            try {
                this.setAttributes(this.fBlock);
            }
            catch (DebugException debugException) {
                CDebugUIPlugin.errorDialog(debugException.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private void setAttributes(SourceLookupBlock sourceLookupBlock) throws DebugException {
        ICDebugTarget iCDebugTarget = this.getDebugTarget();
        if (iCDebugTarget != null && iCDebugTarget.getLaunch().getSourceLocator() instanceof IAdaptable) {
            ICSourceLocator iCSourceLocator;
            IAdaptable iAdaptable = (IAdaptable)iCDebugTarget.getLaunch().getSourceLocator();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz)) != null) {
                iCSourceLocator.setSourceLocations(sourceLookupBlock.getSourceLocations());
                iCSourceLocator.setSearchForDuplicateFiles(sourceLookupBlock.searchForDuplicateFiles());
                if (iCDebugTarget.getLaunch().getSourceLocator() instanceof IPersistableSourceLocator) {
                    ILaunchConfiguration iLaunchConfiguration = iCDebugTarget.getLaunch().getLaunchConfiguration();
                    this.saveChanges(iLaunchConfiguration, (IPersistableSourceLocator)iCDebugTarget.getLaunch().getSourceLocator());
                }
            }
        }
    }

    protected void saveChanges(ILaunchConfiguration iLaunchConfiguration, IPersistableSourceLocator iPersistableSourceLocator) {
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(iLaunchConfiguration.getName());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, iPersistableSourceLocator.getMemento());
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(coreException.getMessage(), null);
        }
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        ICDebugTarget iCDebugTarget = this.getDebugTarget();
        return iCDebugTarget != null ? iCDebugTarget.getLaunch().getLaunchConfiguration() : null;
    }

    public void dispose() {
        if (this.fBlock != null) {
            this.fBlock.dispose();
        }
        super.dispose();
    }
}

