/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import org.eclipse.cdt.internal.ui.editor.asm.AsmCodeScanner;
import org.eclipse.cdt.internal.ui.editor.asm.AsmPartitionScanner;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AsmTextTools {
    private CColorManager fColorManager;
    private AsmCodeScanner fCodeScanner;
    private AsmPartitionScanner fPartitionScanner;
    private CCommentScanner fMultilineCommentScanner;
    private CCommentScanner fSinglelineCommentScanner;
    private SingleTokenCScanner fStringScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public AsmTextTools(IPreferenceStore iPreferenceStore) {
        this(iPreferenceStore, null);
    }

    public AsmTextTools(IPreferenceStore iPreferenceStore, Preferences preferences) {
        if (iPreferenceStore == null) {
            iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        }
        this.fPreferenceStore = iPreferenceStore;
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = preferences;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new CColorManager();
        this.fCodeScanner = new AsmCodeScanner(this.fColorManager, iPreferenceStore);
        this.fPartitionScanner = new AsmPartitionScanner();
        this.fMultilineCommentScanner = new CCommentScanner(this.fColorManager, iPreferenceStore, preferences, "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.fColorManager, iPreferenceStore, preferences, "c_single_line_comment");
        this.fStringScanner = new SingleTokenCScanner((IColorManager)this.fColorManager, iPreferenceStore, "c_string");
    }

    public AsmTextTools() {
        this(null);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fPartitionScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public CColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] stringArray = new String[]{"c_multi_line_comment", "c_single_line_comment", "c_string"};
        return new DefaultPartitioner(this.getPartitionScanner(), stringArray);
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fStringScanner.affectsBehavior(propertyChangeEvent);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fStringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AsmTextTools.this.adaptToPreferenceChange(propertyChangeEvent);
        }

        public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
            AsmTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue()));
        }
    }
}

