/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchOperation;
import org.eclipse.cdt.internal.ui.search.GotoMarkerAction;
import org.eclipse.cdt.internal.ui.search.GroupByKeyComputer;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;

public class CSearchResultCollector
extends BasicSearchResultCollector {
    public static final String IMATCH = CSearchMessages.getString("CSearchResultCollector.4");
    private static final String SEARCHING = CSearchMessages.getString("CSearchResultCollector.searching");
    private static final String MATCH = CSearchMessages.getString("CSearchResultCollector.match");
    private static final String MATCHES = CSearchMessages.getString("CSearchResultCollector.matches");
    private static final String DONE = CSearchMessages.getString("CSearchResultCollector.done");
    private IProgressMonitor _monitor;
    private CSearchOperation _operation;
    private ISearchResultView _view;
    private IGroupByKeyComputer _computer;
    private int _matchCount;

    public void aboutToStart() {
        super.aboutToStart();
        this._matchCount = 0;
        this._view = SearchUI.getSearchResultView();
        CSearchResultLabelProvider cSearchResultLabelProvider = new CSearchResultLabelProvider();
        cSearchResultLabelProvider.setOrder(3);
        this._computer = new GroupByKeyComputer();
        if (this._view != null) {
            this._view.searchStarted(null, this._operation.getSingularLabel(), this._operation.getPluralLabelPattern(), this._operation.getImageDescriptor(), "org.eclipse.cdt.ui.CSearchPage", (ILabelProvider)cSearchResultLabelProvider, (IAction)new GotoMarkerAction(), this._computer, (IRunnableWithProgress)this._operation);
        }
        if (this.getProgressMonitor() != null && !this.getProgressMonitor().isCanceled()) {
            this.getProgressMonitor().subTask(SEARCHING);
        }
    }

    public boolean acceptMatch(IMatch iMatch) throws CoreException {
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)iMatch;
        if (!super.acceptMatch(iMatch)) {
            return false;
        }
        if (basicSearchMatch.resource == null) {
            return false;
        }
        IMarker iMarker = basicSearchMatch.resource.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
        hashMap.put("charStart", new Integer(Math.max(basicSearchMatch.startOffset, 0)));
        hashMap.put("charEnd", new Integer(Math.max(basicSearchMatch.endOffset, 0)));
        hashMap.put(IMATCH, (Integer)basicSearchMatch);
        iMarker.setAttributes(hashMap);
        if (this._view != null) {
            this._view.addMatch(basicSearchMatch.name, this._computer.computeGroupByKey(iMarker), basicSearchMatch.resource, iMarker);
        }
        ++this._matchCount;
        return true;
    }

    public void done() {
        if (!this.getProgressMonitor().isCanceled()) {
            String string = this._matchCount == 1 ? MATCH : MessageFormat.format(MATCHES, new Integer(this._matchCount));
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, string));
        }
        if (this._view != null) {
            this._view.searchFinished();
        }
        this._view = null;
        this._monitor = null;
    }

    public IProgressMonitor getProgressMonitor() {
        return this._monitor;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this._monitor = iProgressMonitor;
    }

    public void setOperation(CSearchOperation cSearchOperation) {
        this._operation = cSearchOperation;
    }
}

