/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class TabFolderOptionBlock {
    protected boolean initializingTabs = true;
    private Composite composite;
    private boolean bShowMessageArea;
    private String fErrorMessage;
    private boolean bIsValid = true;
    private Label messageLabel;
    private ArrayList pages;
    protected ICOptionContainer fParent;
    private ICOptionPage fCurrentPage;
    private TabFolder fFolder;

    public TabFolderOptionBlock(boolean bl) {
        this.bShowMessageArea = bl;
    }

    public TabFolderOptionBlock(ICOptionContainer iCOptionContainer, boolean bl) {
        this.bShowMessageArea = bl;
        this.setOptionContainer(iCOptionContainer);
    }

    public void setOptionContainer(ICOptionContainer iCOptionContainer) {
        this.fParent = iCOptionContainer;
    }

    public TabFolderOptionBlock(ICOptionContainer iCOptionContainer) {
        this(iCOptionContainer, true);
    }

    protected void addOptionPage(ICOptionPage iCOptionPage) {
        if (this.pages == null) {
            this.pages = new ArrayList();
        }
        if (!this.pages.contains(iCOptionPage)) {
            this.pages.add(iCOptionPage);
        }
    }

    protected List getOptionPages() {
        return this.pages;
    }

    public Control createContents(Composite composite) {
        String string;
        this.composite = new Composite(composite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        if (this.bShowMessageArea) {
            this.messageLabel = new Label(this.composite, 16384);
            this.messageLabel.setFont(this.composite.getFont());
            this.messageLabel.setLayoutData((Object)new GridData(768));
            string = new Label(this.composite, 256);
            string.setLayoutData((Object)new GridData(768));
        }
        this.createFolder(this.composite);
        this.addTabs();
        this.setCurrentPage((ICOptionPage)this.pages.get(0));
        this.initializingTabs = false;
        string = ((ICOptionPage)this.pages.get(0)).getDescription();
        if (string != null) {
            this.messageLabel.setText(string);
        }
        return this.composite;
    }

    protected ICOptionPage getStartPage() {
        return (ICOptionPage)this.pages.get(0);
    }

    public int getPageIndex() {
        return this.pages.indexOf(this.getCurrentPage());
    }

    protected void createFolder(Composite composite) {
        this.fFolder = new TabFolder(composite, 0);
        this.fFolder.setLayoutData((Object)new GridData(1808));
        this.fFolder.setLayout((Layout)new TabFolderLayout());
        this.fFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!TabFolderOptionBlock.this.initializingTabs) {
                    TabFolderOptionBlock.this.setCurrentPage((ICOptionPage)((TabItem)selectionEvent.item).getData());
                    TabFolderOptionBlock.this.fParent.updateContainer();
                }
            }
        });
    }

    protected void addTab(ICOptionPage iCOptionPage) {
        TabItem tabItem = new TabItem(this.fFolder, 0);
        tabItem.setText(iCOptionPage.getTitle());
        Image image = iCOptionPage.getImage();
        if (image != null) {
            tabItem.setImage(image);
        }
        tabItem.setData((Object)iCOptionPage);
        iCOptionPage.setContainer(this.fParent);
        iCOptionPage.createControl((Composite)tabItem.getParent());
        tabItem.setControl(iCOptionPage.getControl());
        this.addOptionPage(iCOptionPage);
    }

    protected abstract void addTabs();

    public boolean performApply(IProgressMonitor iProgressMonitor) {
        if (this.initializingTabs) {
            return false;
        }
        Iterator iterator = ((AbstractList)this.pages).iterator();
        while (iterator.hasNext()) {
            ICOptionPage iCOptionPage = (ICOptionPage)iterator.next();
            try {
                iCOptionPage.performApply((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                CUIPlugin.errorDialog(this.composite.getShell(), CUIMessages.getString("TabFolderOptionBlock.error"), CUIMessages.getString("TabFolderOptionBlock.error.settingOptions"), coreException);
                return false;
            }
        }
        return true;
    }

    public void setVisible(boolean bl) {
        if (this.initializingTabs) {
            return;
        }
        if (this.fCurrentPage != null) {
            this.fCurrentPage.setVisible(bl);
        }
        this.update();
    }

    public void update() {
        ICOptionPage iCOptionPage;
        if (this.initializingTabs) {
            return;
        }
        boolean bl = true;
        Iterator iterator = ((AbstractList)this.pages).iterator();
        while (iterator.hasNext()) {
            iCOptionPage = (ICOptionPage)iterator.next();
            bl = iCOptionPage.isValid();
            if (bl) continue;
            this.setErrorMessage(iCOptionPage.getErrorMessage());
            break;
        }
        if (bl) {
            this.setErrorMessage(null);
            iCOptionPage = this.getCurrentPage();
            if (this.bShowMessageArea) {
                this.messageLabel.setText(iCOptionPage.getDescription() != null ? iCOptionPage.getDescription() : "");
            }
        }
        this.setValid(bl);
    }

    private void setValid(boolean bl) {
        this.bIsValid = bl;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean isValid() {
        return this.bIsValid;
    }

    public void performDefaults() {
        if (this.initializingTabs) {
            return;
        }
        this.getCurrentPage().performDefaults();
    }

    public ICOptionPage getCurrentPage() {
        return this.fCurrentPage;
    }

    public void setCurrentPage(ICOptionPage iCOptionPage) {
        ICOptionPage iCOptionPage2 = this.fCurrentPage;
        this.fCurrentPage = iCOptionPage;
        this.fCurrentPage.setVisible(true);
        if (iCOptionPage2 != null) {
            iCOptionPage2.setVisible(false);
        }
    }
}

