/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;

public class CElementDeltaBuilder {
    ICElement cElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    CElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public CElementDeltaBuilder(ICElement iCElement) {
        this.cElement = iCElement;
        this.initialize();
        this.recordElementInfo(iCElement, 0);
    }

    public CElementDeltaBuilder(ICElement iCElement, int n) {
        this.cElement = iCElement;
        this.maxDepth = n;
        this.initialize();
        this.recordElementInfo(iCElement, 0);
    }

    private void added(ICElement iCElement) {
        this.added.add(iCElement);
        ListItem listItem = this.getNewPosition(iCElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getNewPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getNewPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.cElement, 0);
        this.findAdditions(this.cElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.cElement, 0);
        this.trimDelta(this.delta);
    }

    private void findAdditions(ICElement iCElement, int n) {
        ICElement[] iCElementArray;
        CElementInfo cElementInfo = this.getElementInfo(iCElement);
        if (cElementInfo == null && n < this.maxDepth) {
            this.delta.added(iCElement);
            this.added(iCElement);
        } else {
            this.removeElementInfo(iCElement);
        }
        if (n >= this.maxDepth) {
            this.delta.changed(iCElement, 1);
            return;
        }
        CElementInfo cElementInfo2 = null;
        cElementInfo2 = ((CElement)iCElement).getElementInfo();
        this.findContentChange(cElementInfo, cElementInfo2, iCElement);
        if (cElementInfo != null && iCElement instanceof IParent && (iCElementArray = cElementInfo2.getChildren()) != null) {
            int n2 = iCElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.findAdditions(iCElementArray[n3], n + 1);
                ++n3;
            }
        }
    }

    private void findChangesInPositioning(ICElement iCElement, int n) {
        if (n >= this.maxDepth || this.added.contains(iCElement) || this.removed.contains(iCElement)) {
            return;
        }
        if (!this.isPositionedCorrectly(iCElement)) {
            this.delta.removed(iCElement);
            this.delta.added(iCElement);
        }
        if (iCElement instanceof IParent) {
            CElementInfo cElementInfo = null;
            cElementInfo = ((CElement)iCElement).getElementInfo();
            ICElement[] iCElementArray = cElementInfo.getChildren();
            if (iCElementArray != null) {
                int n2 = iCElementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.findChangesInPositioning(iCElementArray[n3], n + 1);
                    ++n3;
                }
            }
        }
    }

    private void findContentChange(CElementInfo cElementInfo, CElementInfo cElementInfo2, ICElement iCElement) {
        if (cElementInfo instanceof SourceManipulationInfo && cElementInfo2 instanceof SourceManipulationInfo) {
            SourceManipulationInfo sourceManipulationInfo = (SourceManipulationInfo)cElementInfo;
            SourceManipulationInfo sourceManipulationInfo2 = (SourceManipulationInfo)cElementInfo2;
            if (sourceManipulationInfo.getModifiers() != sourceManipulationInfo2.getModifiers()) {
                this.delta.changed(iCElement, 2);
            }
            if (!sourceManipulationInfo.hasSameContentsAs(sourceManipulationInfo2)) {
                this.delta.changed(iCElement, 1);
            }
        }
    }

    private void findDeletions() {
        Iterator iterator = this.infos.keySet().iterator();
        while (iterator.hasNext()) {
            ICElement iCElement = (ICElement)iterator.next();
            this.delta.removed(iCElement);
            this.removed(iCElement);
        }
    }

    private CElementInfo getElementInfo(ICElement iCElement) {
        return (CElementInfo)this.infos.get(iCElement);
    }

    private ListItem getNewPosition(ICElement iCElement) {
        return (ListItem)this.newPositions.get(iCElement);
    }

    private ListItem getOldPosition(ICElement iCElement) {
        return (ListItem)this.oldPositions.get(iCElement);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.cElement, new ListItem(null, null));
        this.putNewPosition(this.cElement, new ListItem(null, null));
        this.delta = new CElementDelta(this.cElement);
        if (this.cElement.getElementType() >= 60) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(ICElement[] iCElementArray, boolean bl) {
        int n = iCElementArray.length;
        ICElement iCElement = null;
        ICElement iCElement2 = null;
        ICElement iCElement3 = n > 0 ? iCElementArray[0] : null;
        int n2 = 0;
        while (n2 < n) {
            iCElement = iCElement2;
            iCElement2 = iCElement3;
            ICElement iCElement4 = iCElement3 = n2 + 1 < n ? iCElementArray[n2 + 1] : null;
            if (bl) {
                this.putNewPosition(iCElement2, new ListItem(iCElement, iCElement3));
            } else {
                this.putOldPosition(iCElement2, new ListItem(iCElement, iCElement3));
            }
            ++n2;
        }
    }

    private boolean isIdentical(CElement cElement, CElement cElement2) {
        if (cElement == null ^ cElement2 == null) {
            return false;
        }
        if (cElement == null) {
            return true;
        }
        return cElement.isIdentical(cElement2);
    }

    private boolean isPositionedCorrectly(ICElement iCElement) {
        ListItem listItem = this.getOldPosition(iCElement);
        if (listItem == null) {
            return false;
        }
        ICElement iCElement2 = listItem.previous;
        ListItem listItem2 = this.getNewPosition(iCElement);
        if (listItem2 == null) {
            return false;
        }
        ICElement iCElement3 = listItem2.previous;
        if (iCElement2 == iCElement3) {
            return true;
        }
        ICElement iCElement4 = null;
        while (iCElement4 != iCElement3) {
            if (this.isIdentical((CElement)iCElement2, (CElement)iCElement3)) {
                return true;
            }
            iCElement4 = iCElement3;
            if (iCElement3 == null) break;
            iCElement3 = this.getNewPosition((ICElement)iCElement3).previous;
        }
        return false;
    }

    private void putElementInfo(ICElement iCElement, CElementInfo cElementInfo) {
        this.infos.put(iCElement, cElementInfo);
    }

    private void putNewPosition(ICElement iCElement, ListItem listItem) {
        this.newPositions.put(iCElement, listItem);
    }

    private void putOldPosition(ICElement iCElement, ListItem listItem) {
        this.oldPositions.put(iCElement, listItem);
    }

    private void recordElementInfo(ICElement iCElement, int n) {
        ICElement[] iCElementArray;
        if (n >= this.maxDepth) {
            return;
        }
        CElementInfo cElementInfo = (CElementInfo)CModelManager.getDefault().getInfo(iCElement);
        if (cElementInfo == null) {
            return;
        }
        this.putElementInfo(iCElement, cElementInfo);
        if (iCElement instanceof IParent && (iCElementArray = cElementInfo.getChildren()) != null) {
            this.insertPositions(iCElementArray, false);
            int n2 = 0;
            int n3 = iCElementArray.length;
            while (n2 < n3) {
                this.recordElementInfo(iCElementArray[n2], n + 1);
                ++n2;
            }
        }
    }

    private void recordNewPositions(ICElement iCElement, int n) {
        if (n < this.maxDepth && iCElement instanceof IParent) {
            CElementInfo cElementInfo = null;
            cElementInfo = ((CElement)iCElement).getElementInfo();
            ICElement[] iCElementArray = cElementInfo.getChildren();
            if (iCElementArray != null) {
                this.insertPositions(iCElementArray, true);
                int n2 = 0;
                int n3 = iCElementArray.length;
                while (n2 < n3) {
                    this.recordNewPositions(iCElementArray[n2], n + 1);
                    ++n2;
                }
            }
        }
    }

    private void removed(ICElement iCElement) {
        this.removed.add(iCElement);
        ListItem listItem = this.getOldPosition(iCElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getOldPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getOldPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    private void removeElementInfo(ICElement iCElement) {
        this.infos.remove(iCElement);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Built delta:\n");
        stringBuffer.append(this.delta.toString());
        return stringBuffer.toString();
    }

    private void trimDelta(CElementDelta cElementDelta) {
        if (cElementDelta.getKind() == 2) {
            ICElementDelta[] iCElementDeltaArray = cElementDelta.getAffectedChildren();
            int n = 0;
            int n2 = iCElementDeltaArray.length;
            while (n < n2) {
                cElementDelta.removeAffectedChild((CElementDelta)iCElementDeltaArray[n]);
                ++n;
            }
        } else {
            ICElementDelta[] iCElementDeltaArray = cElementDelta.getAffectedChildren();
            int n = 0;
            int n3 = iCElementDeltaArray.length;
            while (n < n3) {
                this.trimDelta((CElementDelta)iCElementDeltaArray[n]);
                ++n;
            }
        }
    }

    class ListItem {
        public ICElement previous;
        public ICElement next;

        public ListItem(ICElement iCElement, ICElement iCElement2) {
            this.previous = iCElement;
            this.next = iCElement2;
        }
    }
}

