/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public abstract class CreateElementInTUOperation
extends CModelOperation {
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int fInsertionPolicy = 1;
    protected ISourceReference fCreatedElement = null;
    protected ICElement fAnchorElement = null;
    protected boolean fCreationOccurred = true;
    protected int fInsertionPosition = -1;
    protected int fReplacementLength = -1;

    public CreateElementInTUOperation(ICElement iCElement) {
        super(null, new ICElement[]{iCElement});
        this.initializeDefaultPosition();
    }

    protected void checkCanceled() {
        if (!this.fNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(ICElement iCElement) {
        this.setRelativePosition(iCElement, 2);
    }

    public void createBefore(ICElement iCElement) {
        this.setRelativePosition(iCElement, 3);
    }

    protected void executeOperation() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
        CElementDelta cElementDelta = this.newCElementDelta();
        ITranslationUnit iTranslationUnit = this.getTranslationUnit();
        this.insertElement();
        if (this.fCreationOccurred) {
            IBuffer iBuffer = iTranslationUnit.getBuffer();
            if (iBuffer == null) {
                return;
            }
            char[] cArray = iBuffer.getCharacters();
            if (cArray == null) {
                return;
            }
            char[] cArray2 = this.fCreatedElement.getSource().toCharArray();
            switch (this.fReplacementLength) {
                case -1: {
                    iBuffer.append(cArray2);
                    break;
                }
                case 0: {
                    iBuffer.replace(this.fInsertionPosition, 0, cArray2);
                    break;
                }
                default: {
                    iBuffer.replace(this.fInsertionPosition, this.fReplacementLength, this.fCreatedElement.getSource());
                }
            }
            iTranslationUnit.save(null, false);
            boolean bl = iTranslationUnit.isWorkingCopy();
            this.worked(1);
            this.fResultElements = this.generateResultHandles();
            if (!bl && iTranslationUnit.getParent().exists()) {
                int n = 0;
                while (n < this.fResultElements.length) {
                    cElementDelta.added(this.fResultElements[n]);
                    ++n;
                }
                this.addDelta(cElementDelta);
            }
        }
        this.done();
    }

    protected abstract ICElement generateResultHandle();

    protected ICElement[] generateResultHandles() throws CModelException {
        return new ICElement[]{this.generateResultHandle()};
    }

    protected ITranslationUnit getTranslationUnit() {
        return ((ISourceReference)((Object)this.getParentElement())).getTranslationUnit();
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    protected abstract String getMainTaskName();

    public ICElement[] getResultElements() {
        return this.fResultElements;
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertElement() throws CModelException {
        if (this.fInsertionPolicy != 1) {
            ISourceRange iSourceRange = ((ISourceReference)((Object)this.fAnchorElement)).getSourceRange();
            switch (this.fInsertionPolicy) {
                case 2: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = iSourceRange.getStartPos() + iSourceRange.getLength();
                    break;
                }
                case 3: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = iSourceRange.getStartPos();
                }
                default: {
                    this.fReplacementLength = iSourceRange.getStartPos() + iSourceRange.getLength();
                    this.fInsertionPosition = iSourceRange.getStartPos();
                }
            }
            return;
        }
        this.fReplacementLength = -1;
    }

    protected void setAlteredName(String string) {
    }

    protected void setRelativePosition(ICElement iCElement, int n) throws IllegalArgumentException {
        if (iCElement == null) {
            this.fAnchorElement = null;
            this.fInsertionPolicy = 1;
        } else {
            this.fAnchorElement = iCElement;
            this.fInsertionPolicy = n;
        }
    }

    public ICModelStatus verify() {
        ICElement iCElement;
        if (this.getParentElement() == null) {
            return new CModelStatus(968);
        }
        if (this.fAnchorElement != null && !(iCElement = this.fAnchorElement.getParent()).equals(this.getParentElement())) {
            return new CModelStatus(993, this.fAnchorElement);
        }
        return CModelStatus.VERIFIED_OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StringBuffer getContent(IFile iFile) throws CModelException {
        StringBuffer stringBuffer;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        try {
            try {
                char[] cArray = CreateElementInTUOperation.getInputStreamAsCharArray(bufferedInputStream, -1, null);
                stringBuffer = new StringBuffer(cArray.length).append(cArray);
                Object var4_7 = null;
            }
            catch (IOException iOException) {
                throw new CModelException(iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedInputStream == null) return stringBuffer;
        ((InputStream)bufferedInputStream).close();
        return stringBuffer;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n == -1) {
            cArray = new char[]{};
            int n2 = 0;
            int n3 = -1;
            do {
                int n4;
                if (n2 + (n4 = inputStream.available()) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n2 + n4];
                    System.arraycopy(cArray2, 0, cArray, 0, n2);
                }
                if ((n3 = inputStreamReader.read(cArray, n2, n4)) <= 0) continue;
                n2 += n3;
            } while (n3 > 0);
            if (n2 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray3, 0, cArray, 0, n2);
            }
        } else {
            cArray = new char[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStreamReader.read(cArray, n5 += n6, n - n5);
            }
            if (n5 != n) {
                char[] cArray4 = cArray;
                cArray = new char[n5];
                System.arraycopy(cArray4, 0, cArray, 0, n5);
            }
        }
        return cArray;
    }

    void save(StringBuffer stringBuffer, IFile iFile) throws CModelException {
        byte[] byArray = stringBuffer.toString().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            boolean bl = true;
            iFile.setContents((InputStream)byteArrayInputStream, bl, true, null);
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }
}

