/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

public class ReadMemoryAccess {
    byte[] bytes;
    int memOffset;
    byte[] val = new byte[8];
    boolean isle;

    public ReadMemoryAccess(byte[] byArray) {
        this(byArray, true);
    }

    public ReadMemoryAccess(byte[] byArray, boolean bl) {
        this.bytes = byArray;
        this.memOffset = 0;
        this.isle = bl;
    }

    public int getSize() {
        return this.bytes.length - this.memOffset;
    }

    public void getBytes(byte[] byArray) {
        this.getBytes(byArray, this.memOffset);
        this.memOffset += byArray.length;
    }

    public void getBytes(byte[] byArray, int n) {
        this.getBytes(byArray, n, byArray.length);
    }

    public void getBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(this.bytes, n, byArray, 0, n2);
    }

    public byte getByte() {
        return this.getByte(this.memOffset++);
    }

    public short getUnsignedByte() {
        return this.getUnsignedByte(this.memOffset++);
    }

    public byte getByte(int n) {
        return this.bytes[n];
    }

    public short getUnsignedByte(int n) {
        return this.bytes[n];
    }

    public short getShort() {
        if (this.isle) {
            return this.getShortLE();
        }
        return this.getShortBE();
    }

    public int getUnsignedShort() {
        if (this.isle) {
            return this.getUnsignedShortLE();
        }
        return this.getUnsignedShortBE();
    }

    public short getShortLE() {
        short s = this.getShortLE(this.memOffset);
        this.memOffset += 2;
        return s;
    }

    public int getUnsignedShortLE() {
        int n = this.getUnsignedShortLE(this.memOffset);
        this.memOffset += 2;
        return n;
    }

    public short getShortLE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        return ReadMemoryAccess.getShortLE(this.val);
    }

    public static short getShortLE(byte[] byArray) {
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    public int getUnsignedShortLE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        return ReadMemoryAccess.getUnsignedShortLE(this.val);
    }

    public static int getUnsignedShortLE(byte[] byArray) {
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public short getShortBE() {
        short s = this.getShortBE(this.memOffset);
        this.memOffset += 2;
        return s;
    }

    public int getUnsignedShortBE() {
        int n = this.getUnsignedShortBE(this.memOffset);
        this.memOffset += 2;
        return n;
    }

    public short getShortBE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        return ReadMemoryAccess.getShortBE(this.val);
    }

    public static short getShortBE(byte[] byArray) {
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public int getUnsignedShortBE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        return ReadMemoryAccess.getUnsignedShortBE(this.val);
    }

    public static int getUnsignedShortBE(byte[] byArray) {
        return ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
    }

    public int getInt() {
        if (this.isle) {
            return this.getIntLE();
        }
        return this.getIntBE();
    }

    public int getIntLE() {
        int n = this.getIntLE(this.memOffset);
        this.memOffset += 4;
        return n;
    }

    public long getUnsignedIntLE() {
        long l = this.getUnsignedIntLE(this.memOffset);
        this.memOffset += 4;
        return l;
    }

    public long getUnsignedIntLE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        return ReadMemoryAccess.getUnsignedIntLE(this.val);
    }

    public static long getUnsignedIntLE(byte[] byArray) {
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public int getIntLE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        return ReadMemoryAccess.getIntLE(this.val);
    }

    public static int getIntLE(byte[] byArray) {
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public int getIntBE() {
        int n = this.getIntBE(this.memOffset);
        this.memOffset += 4;
        return n;
    }

    public long getUnsignedIntBE() {
        long l = this.getUnsignedIntBE(this.memOffset);
        this.memOffset += 4;
        return l;
    }

    public int getIntBE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        return ReadMemoryAccess.getIntBE(this.val);
    }

    public static int getIntBE(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public long getUnsignedIntBE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        return ReadMemoryAccess.getUnsignedIntBE(this.val);
    }

    public static long getUnsignedIntBE(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public long getLong() {
        if (this.isle) {
            return this.getLongLE();
        }
        return this.getLongBE();
    }

    public long getLongLE() {
        long l = this.getLongLE(this.memOffset);
        this.memOffset += 8;
        return l;
    }

    public long getLongLE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        this.val[4] = this.getByte(n + 4);
        this.val[5] = this.getByte(n + 5);
        this.val[6] = this.getByte(n + 6);
        this.val[7] = this.getByte(n + 7);
        return this.getLongLE(this.val);
    }

    public long getLongLE(byte[] byArray) {
        return (long)(byArray[7] & 0xFF) << 56 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
    }

    public long getLongBE() {
        long l = this.getLongBE(this.memOffset);
        this.memOffset += 8;
        return l;
    }

    public long getLongBE(int n) {
        this.val[0] = this.getByte(n);
        this.val[1] = this.getByte(n + 1);
        this.val[2] = this.getByte(n + 2);
        this.val[3] = this.getByte(n + 3);
        this.val[4] = this.getByte(n + 4);
        this.val[5] = this.getByte(n + 5);
        this.val[6] = this.getByte(n + 6);
        this.val[7] = this.getByte(n + 7);
        return this.getLongBE(this.val);
    }

    public long getLongBE(byte[] byArray) {
        return (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
    }
}

