/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends PEBinaryObject {
    PEArchive.ARHeader header;

    public ARMember(IBinaryParser iBinaryParser, IPath iPath, PEArchive.ARHeader aRHeader) throws IOException {
        super(iBinaryParser, iPath);
        this.header = aRHeader;
    }

    public InputStream getContents() {
        InputStream inputStream = null;
        if (this.path != null && this.header != null) {
            try {
                inputStream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = super.getContents();
        }
        return inputStream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected PE getPE() throws IOException {
        if (this.header != null) {
            return this.header.getPE();
        }
        throw new IOException(CCorePlugin.getResourceString("Util.exception.noFileAssociation"));
    }

    protected void addSymbols(Coff.Symbol[] symbolArray, byte[] byArray, Addr2line addr2line, CPPFilt cPPFilt, CygPath cygPath, List list) {
        int n = 0;
        while (n < symbolArray.length) {
            String string;
            if ((symbolArray[n].isFunction() || symbolArray[n].isPointer() || symbolArray[n].isArray()) && (string = symbolArray[n].getName(byArray)) != null && string.trim().length() != 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
                Symbol symbol = new Symbol(this);
                symbol.type = symbolArray[n].isFunction() ? 1 : 2;
                symbol.name = string;
                symbol.addr = symbolArray[n].n_value;
                list.add(symbol);
            }
            ++n;
        }
    }
}

