/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.tools;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.debug.DebugBaseType;
import org.eclipse.cdt.utils.debug.DebugParameterKind;
import org.eclipse.cdt.utils.debug.DebugType;
import org.eclipse.cdt.utils.debug.DebugVariableKind;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.debug.stabs.Stabs;
import org.eclipse.cdt.utils.elf.Elf;

public class DebugDump
implements IDebugEntryRequestor {
    List list = new ArrayList();
    BufferedWriter bwriter;
    int bracket;
    int paramCount = -1;
    String currentCU;

    public DebugDump(OutputStream outputStream) {
        this.bwriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    void parse(String string) throws IOException {
        Elf elf = new Elf(string);
        this.parse(elf);
        elf.dispose();
    }

    void parse(Elf elf) throws IOException {
        Elf.Attribute attribute = elf.getAttributes();
        int n = attribute.getDebugType();
        if (n == 1) {
            Stabs stabs = new Stabs(elf);
            stabs.parse(this);
        } else if (n == 2) {
            Dwarf dwarf = new Dwarf(elf);
            dwarf.parse(this);
        } else {
            throw new IOException(CCorePlugin.getResourceString("Util.unknownFormat"));
        }
        this.bwriter.flush();
    }

    void write(String string) {
        try {
            this.bwriter.write(string, 0, string.length());
        }
        catch (IOException iOException) {}
    }

    void newLine() {
        try {
            this.bwriter.newLine();
        }
        catch (IOException iOException) {}
    }

    String printTabs() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.bracket) {
            stringBuffer.append('\t');
            ++n;
        }
        return stringBuffer.toString();
    }

    public void enterCompilationUnit(String string, long l) {
        this.write("/* Enter Compilation Unit " + string + " address " + Long.toHexString(l) + " */");
        this.newLine();
        this.currentCU = string;
    }

    public void exitCompilationUnit(long l) {
        this.write("/* Exit Compilation Unit ");
        if (this.currentCU != null) {
            this.write(String.valueOf(this.currentCU) + " address " + Long.toHexString(l));
        }
        this.write(" */");
        this.newLine();
        this.newLine();
        this.currentCU = null;
    }

    public void enterInclude(String string) {
        this.write("#include \"" + string + "\" ");
        this.write("/* Enter Include */");
        this.newLine();
    }

    public void exitInclude() {
    }

    public void enterFunction(String string, DebugType debugType, boolean bl, long l) {
        this.write("/* Func:" + string + " address " + Long.toHexString(l) + " */");
        this.newLine();
        if (!bl) {
            this.write("static ");
        }
        this.write(String.valueOf(debugType.toString()) + " " + string + "(");
        this.paramCount = 0;
    }

    public void exitFunction(long l) {
        if (this.paramCount > -1) {
            this.paramCount = -1;
            this.write(")");
            this.newLine();
            this.write("{");
            this.newLine();
            ++this.bracket;
        }
        while (this.bracket > 0) {
            this.write("}");
            --this.bracket;
        }
        this.write(" /* Exit Func address " + Long.toHexString(l) + " */");
        this.newLine();
        this.newLine();
    }

    public void enterCodeBlock(long l) {
        if (this.paramCount > -1) {
            this.paramCount = -1;
            this.write(")");
            this.newLine();
        }
        this.write(String.valueOf(this.printTabs()) + "{ " + "/* " + l + " */");
        this.newLine();
        ++this.bracket;
    }

    public void exitCodeBlock(long l) {
        --this.bracket;
        this.write(String.valueOf(this.printTabs()) + "} " + "/* " + l + " */");
        this.newLine();
    }

    public void acceptStatement(int n, long l) {
        if (this.paramCount > -1) {
            this.write(")");
            this.newLine();
            this.write("{");
            this.newLine();
            ++this.bracket;
            this.paramCount = -1;
        }
        this.write(String.valueOf(this.printTabs()) + "/* line " + n + " address " + l + " */");
        this.newLine();
    }

    public void acceptIntegerConst(String string, int n) {
        this.write("const int " + string + " = " + n + ";");
        this.newLine();
    }

    public void acceptFloatConst(String string, double d) {
        this.write("const float " + string + " = " + d + ";");
        this.newLine();
    }

    public void acceptTypeConst(String string, DebugType debugType, int n) {
        this.write("const " + debugType.toString() + " " + string + " = " + n + ";");
        this.newLine();
    }

    public void acceptParameter(String string, DebugType debugType, DebugParameterKind debugParameterKind, long l) {
        if (this.paramCount > 0) {
            this.write(", ");
        }
        ++this.paramCount;
        this.write(String.valueOf(debugType.toString()) + " " + string + "/* " + l + " */");
    }

    public void acceptVariable(String string, DebugType debugType, DebugVariableKind debugVariableKind, long l) {
        this.write(String.valueOf(this.printTabs()) + debugType.toString() + " " + string + ";" + "/* " + Long.toHexString(l) + " */");
        this.newLine();
    }

    public void acceptCaughtException(String string, DebugType debugType, long l) {
    }

    public void acceptTypeDef(String string, DebugType debugType) {
        if (!string.equals(debugType.toString())) {
            this.write("typedef " + debugType.toString() + " " + string + ";");
            this.newLine();
        } else if (debugType instanceof DebugBaseType) {
            DebugBaseType debugBaseType = (DebugBaseType)debugType;
            this.write("/* " + string + ": " + debugBaseType.sizeof() + " bytes */");
            this.newLine();
        }
    }

    public static void main(String[] stringArray) {
        try {
            new ByteArrayOutputStream();
            DebugDump debugDump = new DebugDump(System.out);
            debugDump.parse(stringArray[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

