/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class ChangedEvent
implements ICDIChangedEvent {
    Session session;
    ICDIObject source;

    public ChangedEvent(Session session, MIVarChangedEvent mIVarChangedEvent) {
        SessionObject sessionObject;
        this.session = session;
        VariableManager variableManager = (VariableManager)this.session.getVariableManager();
        String string = mIVarChangedEvent.getVarName();
        this.source = variableManager.getVariable(string);
        if (this.source == null) {
            sessionObject = (ExpressionManager)this.session.getExpressionManager();
            this.source = ((ExpressionManager)sessionObject).getExpression(string);
        }
        if (this.source == null) {
            sessionObject = (RegisterManager)this.session.getRegisterManager();
            this.source = ((RegisterManager)sessionObject).getRegister(string);
        }
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public ChangedEvent(Session session, MIRegisterChangedEvent mIRegisterChangedEvent) {
        this.session = session;
        RegisterManager registerManager = (RegisterManager)this.session.getRegisterManager();
        int n = mIRegisterChangedEvent.getNumber();
        this.source = registerManager.getRegister(n);
        if (this.source == null) {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public ChangedEvent(Session session, MIBreakpointChangedEvent mIBreakpointChangedEvent) {
        this.session = session;
        BreakpointManager breakpointManager = (BreakpointManager)this.session.getBreakpointManager();
        int n = mIBreakpointChangedEvent.getNumber();
        Breakpoint breakpoint = breakpointManager.getBreakpoint(n);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session session, MISharedLibChangedEvent mISharedLibChangedEvent) {
        this.session = session;
        SharedLibraryManager sharedLibraryManager = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String string = mISharedLibChangedEvent.getName();
        ICDISharedLibrary iCDISharedLibrary = sharedLibraryManager.getSharedLibrary(string);
        this.source = iCDISharedLibrary != null ? iCDISharedLibrary : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session session, MISignalChangedEvent mISignalChangedEvent) {
        this.session = session;
        SignalManager signalManager = (SignalManager)this.session.getSignalManager();
        String string = mISignalChangedEvent.getName();
        ICDISignal iCDISignal = signalManager.getSignal(string);
        this.source = iCDISignal != null ? iCDISignal : new CObject(this.session.getCurrentTarget());
    }

    public ChangedEvent(Session session, ICDIObject iCDIObject) {
        this.session = session;
        this.source = iCDIObject;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

