/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class CastToArrayActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICastToArray fCastToArray = null;
    private IStatus fStatus = null;
    private IWorkbenchPart fTargetPart = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.fTargetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        if (this.getCastToArray() == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    CastToArrayActionDelegate.this.doAction(CastToArrayActionDelegate.this.getCastToArray());
                    CastToArrayActionDelegate.this.setStatus(null);
                }
                catch (DebugException debugException) {
                    CastToArrayActionDelegate.this.setStatus(debugException.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Unable_to_display_this_variable_as_an_array"), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICastToArray) {
            boolean bl = ((ICastToArray)object).supportsCastToArray();
            iAction.setEnabled(bl);
            if (bl) {
                this.setCastToArray((ICastToArray)object);
                return;
            }
        }
        iAction.setEnabled(false);
        this.setCastToArray(null);
    }

    protected ICastToArray getCastToArray() {
        return this.fCastToArray;
    }

    protected void setCastToArray(ICastToArray iCastToArray) {
        this.fCastToArray = iCastToArray;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    protected void doAction(ICastToArray iCastToArray) throws DebugException {
        String string = iCastToArray.getCurrentType().trim();
        CastToArrayDialog castToArrayDialog = new CastToArrayDialog(CDebugUIPlugin.getActiveWorkbenchShell(), string, 0, 1);
        if (castToArrayDialog.open() == 0) {
            int n = castToArrayDialog.getFirstIndex();
            int n2 = castToArrayDialog.getLength();
            iCastToArray.castToArray(n, n2);
            if (this.getSelectionProvider() != null) {
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)iCastToArray));
            }
        }
    }

    private ISelectionProvider getSelectionProvider() {
        return this.fTargetPart instanceof IDebugView ? ((IDebugView)this.fTargetPart).getViewer() : null;
    }

    protected class CastToArrayDialog
    extends Dialog {
        private String fType = "";
        private int fFirstIndex = 0;
        private int fLength = 0;
        private Button fOkButton;
        private Label fErrorMessageLabel;
        private Text fFirstIndexText;
        private Text fLengthText;

        public CastToArrayDialog(Shell shell, String string, int n, int n2) {
            super(shell);
            this.fType = string == null ? "" : string;
            this.fFirstIndex = n;
            this.fLength = n2;
        }

        protected String getType() {
            return this.fType;
        }

        protected int getFirstIndex() {
            return this.fFirstIndex;
        }

        protected int getLength() {
            return this.fLength;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Shell_Display_As_Array"));
            shell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.showasarray_co.gif"));
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.fOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
            this.fFirstIndexText.setText(String.valueOf(this.fFirstIndex));
            this.fLengthText.setText(String.valueOf(this.fLength));
        }

        protected Label getErrorMessageLabel() {
            return this.fErrorMessageLabel;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.createDialogFields(composite2);
            this.fErrorMessageLabel = new Label(composite2, 0);
            this.fErrorMessageLabel.setLayoutData((Object)new GridData(768));
            this.fErrorMessageLabel.setFont(composite.getFont());
            return composite2;
        }

        private void createDialogFields(Composite composite) {
            Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)4);
            ((GridData)composite2.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels(300);
            ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = true;
            Label label = ControlFactory.createLabel((Composite)composite2, (String)CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Start_index"));
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fFirstIndexText = ControlFactory.createTextField((Composite)composite2);
            this.fFirstIndexText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ CastToArrayDialog this$1;
                {
                    this.this$1 = castToArrayDialog;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.validateInput();
                }
            });
            label = ControlFactory.createLabel((Composite)composite2, (String)CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Length"));
            ((GridData)label.getLayoutData()).horizontalSpan = 3;
            this.fLengthText = ControlFactory.createTextField((Composite)composite2);
            this.fLengthText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ CastToArrayDialog this$1;
                {
                    this.this$1 = castToArrayDialog;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.validateInput();
                }
            });
        }

        protected void validateInput() {
            boolean bl = true;
            String string = "";
            String string2 = this.fFirstIndexText.getText().trim();
            if (string2.length() == 0) {
                string = CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.First_index_field_must_not_be_empty");
                bl = false;
            } else {
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    string = CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.7");
                    bl = false;
                }
                if (bl) {
                    String string3 = this.fLengthText.getText().trim();
                    if (string3.length() == 0) {
                        string = CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Invalid_first_index");
                        bl = false;
                    } else {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string = CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.Invalid_last_index.");
                            bl = false;
                        }
                        if (bl && n < 1) {
                            string = CDebugUIPlugin.getResourceString("internal.ui.actions.CastToArrayActionDelegate.The_length_must_be_greater_than_0");
                            bl = false;
                        }
                    }
                }
            }
            this.fOkButton.setEnabled(bl);
            this.getErrorMessageLabel().setText(string);
        }

        protected void buttonPressed(int n) {
            if (n == 0) {
                String string = this.fFirstIndexText.getText().trim();
                String string2 = this.fLengthText.getText().trim();
                try {
                    this.fFirstIndex = Integer.parseInt(string);
                    this.fLength = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fFirstIndex = 0;
                    this.fLength = 0;
                }
            } else {
                this.fType = null;
            }
            super.buttonPressed(n);
        }
    }
}

