/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddProjectSourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.SourceLocationWizardNode;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.INewSourceLocationWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SourceLocationSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String PAGE_NAME = CDebugUIPlugin.getResourceString("internal.ui.preferences.SourceLocationSelectionPage.Add_Source_Location");
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;
    protected TableViewer fWizardSelectionViewer;
    protected Object[] fElements = null;

    public SourceLocationSelectionPage(ICSourceLocation[] iCSourceLocationArray) {
        super(PAGE_NAME);
        this.setTitle(CDebugUIPlugin.getResourceString("internal.ui.preferences.SourceLocationSelectionPage.WindowTitle"));
        this.setImageDescriptor(CDebugImages.DESC_WIZBAN_ADD_SOURCE_LOCATION);
        this.fElements = new Object[]{new AddProjectSourceLocationWizard(this.getProjectList(iCSourceLocationArray)), new AddDirectorySourceLocationWizard()};
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        new Label(composite2, 0).setText(CDebugUIPlugin.getResourceString("internal.ui.preferences.SourceLocationSelectionPage.Select_source_location_type"));
        Table table = new Table(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 200;
        table.setLayoutData((Object)gridData);
        this.fWizardSelectionViewer = new TableViewer(table);
        this.fWizardSelectionViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return SourceLocationSelectionPage.this.fElements;
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }
        });
        this.fWizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof AddProjectSourceLocationWizard) {
                    return CDebugUIPlugin.getResourceString("internal.ui.preferences.SourceLocationSelectionPage.Existing_Project_Into_Workspace");
                }
                if (object instanceof AddDirectorySourceLocationWizard) {
                    return CDebugUIPlugin.getResourceString("internal.ui.preferences.SourceLocationSelectionPage.File_System_Directory");
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object instanceof AddProjectSourceLocationWizard) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.addprjsource_wiz.gif");
                }
                if (object instanceof AddDirectorySourceLocationWizard) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.adddirsource_wiz.gif");
                }
                return super.getImage(object);
            }
        });
        this.fWizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fWizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.fWizardSelectionViewer.setInput((Object)this.fElements);
        this.fWizardSelectionViewer.setSelection((ISelection)new StructuredSelection(this.fElements[0]));
        this.setControl((Control)composite2);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        INewSourceLocationWizard iNewSourceLocationWizard = (INewSourceLocationWizard)iStructuredSelection.getFirstElement();
        if (iNewSourceLocationWizard == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(iNewSourceLocationWizard));
        this.setMessage(iNewSourceLocationWizard.getDescription());
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.fWizardSelectionViewer, this.fWizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private IWizardNode createWizardNode(INewSourceLocationWizard iNewSourceLocationWizard) {
        return new SourceLocationWizardNode(iNewSourceLocationWizard);
    }

    public void dispose() {
        if (this.fElements != null) {
            int n = 0;
            while (n < this.fElements.length) {
                ((INewSourceLocationWizard)this.fElements[n]).dispose();
                ++n;
            }
            this.fElements = null;
        }
        super.dispose();
    }

    public ICSourceLocation getSourceLocation() {
        return ((INewSourceLocationWizard)this.getSelectedNode().getWizard()).getSourceLocation();
    }

    private IProject[] getProjectList(ICSourceLocation[] iCSourceLocationArray) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>(iCSourceLocationArray.length);
        int n = 0;
        while (n < iCSourceLocationArray.length) {
            if (iCSourceLocationArray[n] instanceof IProjectSourceLocation) {
                arrayList.add(((IProjectSourceLocation)iCSourceLocationArray[n]).getProject());
            }
            ++n;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> arrayList2 = new ArrayList<IProject>(iProjectArray.length);
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            if ((CoreModel.getDefault().hasCNature(iProjectArray[n2]) || CoreModel.getDefault().hasCNature(iProjectArray[n2])) && iProjectArray[n2].isOpen() && !arrayList.contains(iProjectArray[n2])) {
                arrayList2.add(iProjectArray[n2]);
            }
            ++n2;
        }
        return arrayList2.toArray(new IProject[arrayList2.size()]);
    }
}

