/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.runtime.CoreException;

public class MultiTextEdit {
    private List fChildren;

    public MultiTextEdit() {
        this.fChildren = new ArrayList(3);
    }

    protected MultiTextEdit(List list) throws CoreException {
        this.fChildren = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.fChildren.add(((TextEdit)iterator.next()).copy());
        }
    }

    protected List getChildren() {
        return this.fChildren;
    }

    public void add(MultiTextEdit multiTextEdit) {
        Assert.isNotNull((Object)multiTextEdit);
        this.fChildren.add(multiTextEdit);
    }

    public void add(TextEdit textEdit) {
        Assert.isNotNull((Object)textEdit);
        this.fChildren.add(textEdit);
    }

    public Iterator iterator() {
        return this.fChildren.iterator();
    }

    public void connect(TextBufferEditor textBufferEditor) throws CoreException {
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TextEdit) {
                textBufferEditor.add((TextEdit)e);
                continue;
            }
            textBufferEditor.add((MultiTextEdit)e);
        }
    }

    public MultiTextEdit copy() throws CoreException {
        return new MultiTextEdit(this.fChildren);
    }

    public TextRange getTextRange() {
        int n = this.fChildren.size();
        if (n == 0) {
            return new TextRange(0, 0);
        }
        TextRange textRange = ((TextEdit)this.fChildren.get(0)).getTextRange();
        int n2 = textRange.getOffset();
        int n3 = textRange.getInclusiveEnd();
        int n4 = 1;
        while (n4 < n) {
            textRange = ((TextEdit)this.fChildren.get(n4)).getTextRange();
            n2 = Math.min(n2, textRange.getOffset());
            n3 = Math.max(n3, textRange.getInclusiveEnd());
            ++n4;
        }
        return new TextRange(n2, n3 - n2 + 1);
    }

    public Object getModifiedElement() {
        return null;
    }
}

