/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import java.util.Stack;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.ui.compare.CNode;
import org.eclipse.cdt.internal.ui.compare.SourceElementRequestorAdapter;
import org.eclipse.jface.text.IDocument;

public class CParseTreeBuilder
extends SourceElementRequestorAdapter {
    private Stack fStack = new Stack();
    private IDocument fDocument;

    public CParseTreeBuilder(CNode cNode, IDocument iDocument) {
        this.fDocument = iDocument;
        this.fStack.clear();
        this.fStack.push(cNode);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        String string = iASTClassSpecifier.getName();
        int n = iASTClassSpecifier.getStartingOffset();
        if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
            this.push(64, string, n);
        } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
            this.push(65, string, n);
        } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
            this.push(66, string, n);
        } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.ENUM)) {
            this.push(63, string, n);
        }
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.push(60, "Translation Unit", 0);
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.push(71, iASTFunction.getName(), iASTFunction.getStartingOffset());
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        this.push(72, iASTInclusion.getName(), iASTInclusion.getStartingOffset());
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.push(2048, iASTLinkageSpecification.getLinkageString(), iASTLinkageSpecification.getStartingOffset());
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.push(67, iASTMethod.getName(), iASTMethod.getStartingOffset());
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.push(61, iASTNamespaceDefinition.getName(), iASTNamespaceDefinition.getStartingOffset());
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
        this.push(84, "export", iASTTemplateDeclaration.getStartingOffset());
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
        this.push(84, "template instantiation", iASTTemplateInstantiation.getStartingOffset());
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
        this.push(84, "template specialization", iASTTemplateSpecialization.getStartingOffset());
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.pop(iASTClassSpecifier.getEndingOffset());
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.pop(this.fDocument.getLength());
    }

    public void exitFunctionBody(IASTFunction iASTFunction) {
        this.pop(iASTFunction.getEndingOffset());
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        this.pop(iASTInclusion.getEndingOffset());
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.pop(iASTLinkageSpecification.getEndingOffset());
    }

    public void exitMethodBody(IASTMethod iASTMethod) {
        this.pop(iASTMethod.getEndingOffset());
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.pop(iASTNamespaceDefinition.getEndingOffset());
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
        this.pop(iASTTemplateDeclaration.getEndingOffset());
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation iASTTemplateInstantiation) {
        this.pop(iASTTemplateInstantiation.getEndingOffset());
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization iASTTemplateSpecialization) {
        this.pop(iASTTemplateSpecialization.getEndingOffset());
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.push(63, iASTEnumerationSpecifier.getName(), iASTEnumerationSpecifier.getStartingOffset());
        this.pop(iASTEnumerationSpecifier.getEndingOffset());
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.push(70, iASTFunction.getName(), iASTFunction.getStartingOffset());
        this.pop(iASTFunction.getEndingOffset());
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        this.push(77, iASTMacro.getName(), iASTMacro.getStartingOffset());
        this.pop(iASTMacro.getEndingOffset());
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.push(68, iASTMethod.getName(), iASTMethod.getStartingOffset());
        this.pop(iASTMethod.getEndingOffset());
    }

    public boolean acceptProblem(IProblem iProblem) {
        int n = iProblem.getID();
        if (iProblem.isError() && (n & 0x4000000) != 0) {
            throw new ParseError();
        }
        return true;
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.push(78, iASTTypedefDeclaration.getName(), iASTTypedefDeclaration.getStartingOffset());
        this.pop(iASTTypedefDeclaration.getEndingOffset());
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration iASTUsingDeclaration) {
        this.push(62, iASTUsingDeclaration.usingTypeName(), iASTUsingDeclaration.getStartingOffset());
        this.pop(iASTUsingDeclaration.getEndingOffset());
    }

    public void acceptUsingDirective(IASTUsingDirective iASTUsingDirective) {
        this.push(62, iASTUsingDirective.getNamespaceName(), iASTUsingDirective.getStartingOffset());
        this.pop(iASTUsingDirective.getEndingOffset());
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.push(74, iASTVariable.getName(), iASTVariable.getStartingOffset());
        this.pop(iASTVariable.getEndingOffset());
    }

    public void acceptField(IASTField iASTField) {
        this.push(69, iASTField.getName(), iASTField.getStartingOffset());
        this.pop(iASTField.getEndingOffset());
    }

    private CNode getCurrentContainer() {
        return (CNode)((Object)this.fStack.peek());
    }

    private void push(int n, String string, int n2) {
        this.fStack.push(new CNode(this.getCurrentContainer(), n, string, n2, 0));
    }

    private void pop(int n) {
        CNode cNode = this.getCurrentContainer();
        if (cNode.getTypeCode() == 60) {
            cNode.setAppendPosition(n + 1);
        } else {
            cNode.setAppendPosition(n);
        }
        cNode.setLength(n - cNode.getRange().getOffset() + 1);
        this.fStack.pop();
    }

    public class ParseError
    extends Error {
    }
}

