/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.List;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(CViewMessages.getString("PasteAction.title"));
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(CViewMessages.getString("PasteAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.paste_action_context");
    }

    private IResource getTarget() {
        List list = this.getSelectedResources();
        int n = 0;
        while (n < list.size()) {
            IResource iResource = (IResource)list.get(n);
            if (iResource instanceof IProject && !((IProject)iResource).isOpen()) {
                return null;
            }
            if (iResource.getType() == 1) {
                iResource = iResource.getParent();
            }
            if (iResource != null) {
                return iResource;
            }
            ++n;
        }
        return null;
    }

    private boolean isLinked(IResource[] iResourceArray) {
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].isLinked()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void run() {
        ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
        IResource[] iResourceArray = (IResource[])this.clipboard.getContents((Transfer)resourceTransfer);
        if (iResourceArray != null && iResourceArray.length > 0) {
            if (iResourceArray[0].getType() == 4) {
                int n = 0;
                while (n < iResourceArray.length) {
                    CopyProjectOperation copyProjectOperation = new CopyProjectOperation(this.shell);
                    copyProjectOperation.copyProject((IProject)iResourceArray[n]);
                    ++n;
                }
            } else {
                IContainer iContainer = this.getContainer();
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
                copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] stringArray = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (stringArray != null) {
            IContainer iContainer = this.getContainer();
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
            copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
        }
    }

    private IContainer getContainer() {
        List list = this.getSelectedResources();
        if (list.get(0) instanceof IFile) {
            return ((IFile)list.get(0)).getParent();
        }
        return (IContainer)list.get(0);
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        FileTransfer fileTransfer;
        int n;
        boolean bl;
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        final IResource[][] iResourceArray = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
                iResourceArray[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resourceTransfer);
            }
        });
        IResource[] iResourceArray2 = iResourceArray[0];
        boolean bl2 = bl = iResourceArray2 != null && iResourceArray2.length > 0 && iResourceArray2[0].getType() == 4;
        if (bl) {
            int n2 = 0;
            while (n2 < iResourceArray2.length) {
                if (iResourceArray2[n2].getType() != 4 || !((IProject)iResourceArray2[n2]).isOpen()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource iResource = this.getTarget();
        if (iResource == null) {
            return false;
        }
        List list = this.getSelectedResources();
        if (list.size() > 1) {
            n = 0;
            while (n < list.size()) {
                fileTransfer = (IResource)list.get(n);
                if (fileTransfer.getType() != 1) {
                    return false;
                }
                if (!iResource.equals((Object)fileTransfer.getParent())) {
                    return false;
                }
                ++n;
            }
        }
        if (iResourceArray2 != null) {
            if (this.isLinked(iResourceArray2) && iResource.getType() != 4) {
                return false;
            }
            if (iResource.getType() == 2) {
                n = 0;
                while (n < iResourceArray2.length) {
                    if (iResource.equals((Object)iResourceArray2[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        TransferData[] transferDataArray = this.clipboard.getAvailableTypes();
        fileTransfer = FileTransfer.getInstance();
        int n3 = 0;
        while (n3 < transferDataArray.length) {
            if (fileTransfer.isSupportedType(transferDataArray[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

