/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.link;

import org.eclipse.cdt.internal.ui.text.link.LinkedPositionListener;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LinkedPositionUI
implements LinkedPositionListener,
ITextInputListener,
ModifyListener,
VerifyListener,
VerifyKeyListener,
PaintListener,
IPropertyChangeListener {
    private static final int UNINSTALL = 1;
    public static final int COMMIT = 2;
    private static final int DOCUMENT_CHANGED = 4;
    public static final int UPDATE_CARET = 8;
    private static final String CARET_POSITION = "LinkedPositionUI.caret.position";
    private static final IPositionUpdater fgUpdater = new DefaultPositionUpdater("LinkedPositionUI.caret.position");
    private static final IPreferenceStore fgStore = CUIPlugin.getDefault().getPreferenceStore();
    private final ITextViewer fViewer;
    private final LinkedPositionManager fManager;
    private Color fFrameColor;
    private int fFinalCaretOffset = -1;
    private Position fFramePosition;
    private int fCaretOffset;
    private ExitPolicy fExitPolicy;
    private ExitListener fExitListener;

    public LinkedPositionUI(ITextViewer iTextViewer, LinkedPositionManager linkedPositionManager) {
        Assert.isNotNull((Object)iTextViewer);
        Assert.isNotNull((Object)linkedPositionManager);
        this.fViewer = iTextViewer;
        this.fManager = linkedPositionManager;
        this.fManager.setLinkedPositionListener(this);
        this.initializeHighlightColor(iTextViewer);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("linkedPositionColor")) {
            this.initializeHighlightColor(this.fViewer);
            this.redrawRegion();
        }
    }

    private void initializeHighlightColor(ITextViewer iTextViewer) {
        StyledText styledText;
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
        }
        if ((styledText = iTextViewer.getTextWidget()) != null) {
            Display display = styledText.getDisplay();
            this.fFrameColor = this.createColor(fgStore, "linkedPositionColor", display);
        }
    }

    private Color createColor(IPreferenceStore iPreferenceStore, String string, Display display) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string) && (rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string)) != null) {
            return new Color((Device)display, rGB);
        }
        return null;
    }

    public void setFinalCaretOffset(int n) {
        this.fFinalCaretOffset = n;
    }

    public void setCancelListener(ExitListener exitListener) {
        this.fExitListener = exitListener;
    }

    public void setCurrentPosition(Position position, int n) {
        if (!this.fFramePosition.equals((Object)position)) {
            this.redrawRegion();
            this.fFramePosition = position;
        }
        this.fCaretOffset = n;
    }

    public void setExitPolicy(ExitPolicy exitPolicy) {
        this.fExitPolicy = exitPolicy;
    }

    public void enter() {
        IDocument iDocument = this.fViewer.getDocument();
        iDocument.addPositionCategory(CARET_POSITION);
        iDocument.addPositionUpdater(fgUpdater);
        try {
            if (this.fFinalCaretOffset != -1) {
                iDocument.addPosition(CARET_POSITION, new Position(this.fFinalCaretOffset));
            }
        }
        catch (BadLocationException badLocationException) {
            LinkedPositionUI.openErrorDialog(this.fViewer.getTextWidget().getShell(), (Exception)((Object)badLocationException));
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            CUIPlugin.getDefault().log(badPositionCategoryException);
            Assert.isTrue((boolean)false);
        }
        this.fViewer.addTextInputListener((ITextInputListener)this);
        ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)this.fViewer;
        iTextViewerExtension.prependVerifyKeyListener((VerifyKeyListener)this);
        StyledText styledText = this.fViewer.getTextWidget();
        styledText.addVerifyListener((VerifyListener)this);
        styledText.addModifyListener((ModifyListener)this);
        styledText.addPaintListener((PaintListener)this);
        styledText.showSelection();
        this.fFramePosition = this.fManager.getFirstPosition();
        if (this.fFramePosition == null) {
            this.leave(11);
        }
        fgStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void exit(boolean bl) {
        this.leave((bl ? 2 : 0) | 8);
    }

    public IRegion getSelectedRegion() {
        if (this.fFramePosition == null) {
            return new Region(this.fFinalCaretOffset, 0);
        }
        return new Region(this.fFramePosition.getOffset(), this.fFramePosition.getLength());
    }

    private void leave(int n) {
        if ((n & 1) != 0) {
            this.fManager.uninstall((n & 2) != 0);
        }
        fgStore.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fFrameColor != null) {
            this.fFrameColor.dispose();
            this.fFrameColor = null;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        styledText.removePaintListener((PaintListener)this);
        styledText.removeModifyListener((ModifyListener)this);
        styledText.removeVerifyListener((VerifyListener)this);
        ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)this.fViewer;
        iTextViewerExtension.removeVerifyKeyListener((VerifyKeyListener)this);
        this.fViewer.removeTextInputListener((ITextInputListener)this);
        try {
            int n2;
            Position[] positionArray;
            IRegion iRegion = this.fViewer.getVisibleRegion();
            IDocument iDocument = this.fViewer.getDocument();
            if ((n & 2) != 0 && (n & 4) == 0 && (n & 8) != 0 && (positionArray = iDocument.getPositions(CARET_POSITION)) != null && positionArray.length != 0 && (n2 = positionArray[0].getOffset() - iRegion.getOffset()) >= 0 && n2 <= iRegion.getLength()) {
                styledText.setSelection(n2, n2);
            }
            iDocument.removePositionUpdater(fgUpdater);
            iDocument.removePositionCategory(CARET_POSITION);
            if (this.fExitListener != null) {
                this.fExitListener.exit((n & 2) != 0 || (n & 4) != 0);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            CUIPlugin.getDefault().log(badPositionCategoryException);
            Assert.isTrue((boolean)false);
        }
        if ((n & 4) == 0) {
            styledText.redraw();
        }
    }

    private void next() {
        this.redrawRegion();
        this.fFramePosition = this.fManager.getNextPosition(this.fFramePosition.getOffset());
        if (this.fFramePosition == null) {
            this.leave(11);
        } else {
            this.selectRegion();
            this.redrawRegion();
        }
    }

    private void previous() {
        this.redrawRegion();
        Position position = this.fManager.getPreviousPosition(this.fFramePosition.getOffset());
        if (position == null) {
            this.fViewer.getTextWidget().getDisplay().beep();
        } else {
            this.fFramePosition = position;
            this.selectRegion();
            this.redrawRegion();
        }
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        ExitFlags exitFlags;
        if (!verifyEvent.doit) {
            return;
        }
        Point point = this.fViewer.getSelectedRange();
        int n = point.x;
        int n2 = point.y;
        ExitFlags exitFlags2 = exitFlags = this.fExitPolicy == null ? null : this.fExitPolicy.doExit(this.fManager, verifyEvent, n, n2);
        if (exitFlags != null) {
            this.leave(1 | exitFlags.flags);
            verifyEvent.doit = exitFlags.doit;
            return;
        }
        switch (verifyEvent.character) {
            case '\t': {
                point = this.fViewer.getTextWidget().getSelection();
                IRegion iRegion = this.fViewer.getVisibleRegion();
                n = point.x + iRegion.getOffset();
                n2 = point.y - point.x;
                if (!LinkedPositionManager.includes(this.fFramePosition, n, n2)) {
                    this.leave(11);
                    return;
                }
                if (verifyEvent.stateMask == 131072) {
                    this.previous();
                } else {
                    this.next();
                }
                verifyEvent.doit = false;
                break;
            }
            case '\r': {
                this.leave(11);
                verifyEvent.doit = false;
                break;
            }
            case '\u001b': {
                this.leave(3);
                verifyEvent.doit = false;
                break;
            }
            case ';': {
                this.leave(3);
                verifyEvent.doit = true;
            }
        }
    }

    public void verifyText(VerifyEvent verifyEvent) {
        int n;
        if (!verifyEvent.doit) {
            return;
        }
        IRegion iRegion = this.fViewer.getVisibleRegion();
        int n2 = verifyEvent.start + iRegion.getOffset();
        if (!this.fManager.anyPositionIncludes(n2, n = verifyEvent.end - verifyEvent.start)) {
            this.leave(3);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.fFramePosition == null) {
            return;
        }
        IRegion iRegion = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(iRegion, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int n = this.fFramePosition.getOffset() - iRegion.getOffset();
        int n2 = this.fFramePosition.getLength();
        StyledText styledText = this.fViewer.getTextWidget();
        Point point = LinkedPositionUI.getMinimumLocation(styledText, n, n2);
        Point point2 = LinkedPositionUI.getMaximumLocation(styledText, n, n2);
        int n3 = point.x;
        int n4 = point.x + point2.x - point.x - 1;
        int n5 = point.y + styledText.getLineHeight() - 1;
        GC gC = paintEvent.gc;
        gC.setForeground(this.fFrameColor);
        gC.drawLine(n3, n5, n4, n5);
    }

    private static Point getMinimumLocation(StyledText styledText, int n, int n2) {
        Point point = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int n3 = 0;
        while (n3 <= n2) {
            Point point2 = styledText.getLocationAtOffset(n + n3);
            if (point2.x < point.x) {
                point.x = point2.x;
            }
            if (point2.y < point.y) {
                point.y = point2.y;
            }
            ++n3;
        }
        return point;
    }

    private static Point getMaximumLocation(StyledText styledText, int n, int n2) {
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int n3 = 0;
        while (n3 <= n2) {
            Point point2 = styledText.getLocationAtOffset(n + n3);
            if (point2.x > point.x) {
                point.x = point2.x;
            }
            if (point2.y > point.y) {
                point.y = point2.y;
            }
            ++n3;
        }
        return point;
    }

    private void redrawRegion() {
        IRegion iRegion = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(iRegion, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int n = this.fFramePosition.getOffset() - iRegion.getOffset();
        int n2 = this.fFramePosition.getLength();
        this.fViewer.getTextWidget().redrawRange(n, n2, true);
    }

    private void selectRegion() {
        IRegion iRegion = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(iRegion, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int n = this.fFramePosition.getOffset() - iRegion.getOffset();
        int n2 = this.fFramePosition.getLength() + n;
        this.fViewer.getTextWidget().setSelection(n, n2);
    }

    private void updateCaret() {
        IRegion iRegion = this.fViewer.getVisibleRegion();
        if (!LinkedPositionUI.includes(iRegion, this.fFramePosition)) {
            this.leave(7);
            return;
        }
        int n = this.fFramePosition.getOffset() + this.fCaretOffset - iRegion.getOffset();
        if (n >= 0 && n <= iRegion.getLength()) {
            this.fViewer.getTextWidget().setCaretOffset(n);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.redrawRegion();
        this.updateCaret();
    }

    private static void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)LinkedPositionMessages.getString("LinkedPositionUI.error.title"), (String)exception.getMessage());
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        int n = 3 | (iDocument.equals(iDocument2) ? 0 : 4);
        this.leave(n);
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
    }

    private static boolean includes(IRegion iRegion, Position position) {
        return position.getOffset() >= iRegion.getOffset() && position.getOffset() + position.getLength() <= iRegion.getOffset() + iRegion.getLength();
    }

    public interface ExitListener {
        public void exit(boolean var1);
    }

    public static class ExitFlags {
        public int flags;
        public boolean doit;

        public ExitFlags(int n, boolean bl) {
            this.flags = n;
            this.doit = bl;
        }
    }

    public interface ExitPolicy {
        public ExitFlags doExit(LinkedPositionManager var1, VerifyEvent var2, int var3, int var4);
    }
}

