/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.Templates;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContextType;
import org.eclipse.cdt.internal.corext.template.c.ICompilationUnit;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.template.TemplateLabelProvider;
import org.eclipse.cdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITableLabelProvider;

public class TemplateEngine {
    private ContextType fContextType;
    private ITableLabelProvider fLabelProvider = new TemplateLabelProvider();
    private ArrayList fProposals = new ArrayList();

    public TemplateEngine(ContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public List getResults() {
        return this.fProposals;
    }

    public void complete(ITextViewer iTextViewer, int n, ICompilationUnit iCompilationUnit) {
        IDocument iDocument = iTextViewer.getDocument();
        if (LinkedPositionManager.hasActiveManager(iDocument)) {
            return;
        }
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        ((CompilationUnitContextType)this.fContextType).setContextParameters(iDocument.get(), n, iCompilationUnit);
        CompilationUnitContext compilationUnitContext = (CompilationUnitContext)this.fContextType.createContext();
        int n2 = compilationUnitContext.getStart();
        int n3 = compilationUnitContext.getEnd();
        Region region = new Region(n2, n3 - n2);
        Template[] templateArray = Templates.getInstance().getTemplates();
        int n4 = 0;
        while (n4 != templateArray.length) {
            if (compilationUnitContext.canEvaluate(templateArray[n4])) {
                this.fProposals.add(new TemplateProposal(templateArray[n4], compilationUnitContext, (IRegion)region, iTextViewer, this.fLabelProvider.getColumnImage((Object)templateArray[n4], 0)));
            }
            ++n4;
        }
    }
}

