/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.LinkedList;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;

public class StructuralParseCallback
extends QuickParseCallback {
    protected LinkedList scopeStack = new LinkedList();
    protected IASTScope currentScope = null;
    protected int inclusionLevel = 0;

    private void addElement(IASTDeclaration iASTDeclaration) {
        if (this.inclusionLevel == 0) {
            ((ASTScope)this.currentScope).addDeclaration(iASTDeclaration);
        }
    }

    private void enterScope(IASTNode iASTNode) {
        if (iASTNode instanceof IASTScope) {
            this.pushScope((IASTScope)iASTNode);
        }
    }

    private void exitScope(IASTNode iASTNode) {
        if (iASTNode instanceof IASTScope) {
            this.popScope();
        }
    }

    private void pushScope(IASTScope iASTScope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = iASTScope;
    }

    private IASTScope popScope() {
        IASTScope iASTScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return iASTScope;
    }

    public void acceptMacro(IASTMacro iASTMacro) {
        if (this.inclusionLevel == 0) {
            this.macros.add(iASTMacro);
        }
    }

    public void acceptVariable(IASTVariable iASTVariable) {
        this.addElement(iASTVariable);
    }

    public void acceptFunctionDeclaration(IASTFunction iASTFunction) {
        this.addElement(iASTFunction);
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration iASTTypedefDeclaration) {
        this.addElement(iASTTypedefDeclaration);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        this.enterScope(iASTEnumerationSpecifier);
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        this.enterScope(iASTElaboratedTypeSpecifier);
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration) {
        this.addElement(iASTAbstractTypeSpecifierDeclaration);
    }

    public void enterInclusion(IASTInclusion iASTInclusion) {
        if (this.inclusionLevel == 0) {
            this.inclusions.add(iASTInclusion);
        }
        ++this.inclusionLevel;
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.addElement(iASTNamespaceDefinition);
        this.enterScope(iASTNamespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.enterScope(iASTClassSpecifier);
    }

    public void enterLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.enterScope(iASTLinkageSpecification);
    }

    public void enterCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.enterScope(iASTCompilationUnit);
    }

    public void acceptMethodDeclaration(IASTMethod iASTMethod) {
        this.addElement(iASTMethod);
    }

    public void acceptField(IASTField iASTField) {
        this.addElement(iASTField);
    }

    public void exitCompilationUnit(IASTCompilationUnit iASTCompilationUnit) {
        this.exitScope(iASTCompilationUnit);
        this.compilationUnit = iASTCompilationUnit;
    }

    public void exitInclusion(IASTInclusion iASTInclusion) {
        --this.inclusionLevel;
    }

    public IASTCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void exitClassSpecifier(IASTClassSpecifier iASTClassSpecifier) {
        this.exitScope(iASTClassSpecifier);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification iASTLinkageSpecification) {
        this.exitScope(iASTLinkageSpecification);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition iASTNamespaceDefinition) {
        this.exitScope(iASTNamespaceDefinition);
    }

    public void enterFunctionBody(IASTFunction iASTFunction) {
        this.addElement(iASTFunction);
    }

    public void enterMethodBody(IASTMethod iASTMethod) {
        this.addElement(iASTMethod);
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration iASTTemplateDeclaration) {
        this.addElement(iASTTemplateDeclaration);
    }
}

