/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTElaboratedTypeSpecifier
extends ASTSymbol
implements IASTElaboratedTypeSpecifier {
    private List references;
    private final boolean isForwardDeclaration;
    private final ASTClassKind kind;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTReferenceStore store;

    public ASTElaboratedTypeSpecifier(ISymbol iSymbol, ASTClassKind aSTClassKind, int n, int n2, int n3, int n4, int n5, int n6, int n7, List list, boolean bl) {
        super(iSymbol);
        this.kind = aSTClassKind;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setNameOffset(n3);
        this.setNameEndOffsetAndLineNumber(n4, n5);
        this.setEndingOffsetAndLineNumber(n6, n7);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), iSymbol.getName());
        this.store = new ASTReferenceStore(list);
        this.isForwardDeclaration = bl;
        this.references = list;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public ASTClassKind getClassKind() {
        return this.kind;
    }

    public boolean isResolved() {
        return !this.getSymbol().isForwardDeclaration();
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        if (this.isForwardDeclaration) {
            try {
                iSourceElementRequestor.acceptElaboratedForewardDeclaration(this);
            }
            catch (Exception exception) {}
        }
        this.store.processReferences(iSourceElementRequestor);
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int n) {
        this.offsets.setNameOffset(n);
    }

    public List getReferences() {
        return this.references;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.offsets.setNameEndOffsetAndLineNumber(n, n2);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

