/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;

public class ASTUsingDirective
extends ASTAnonymousDeclaration
implements IASTUsingDirective {
    private final IUsingDirectiveSymbol using;
    private Offsets offsets = new Offsets();
    private final ASTReferenceStore referenceDelegate;

    public ASTUsingDirective(IContainerSymbol iContainerSymbol, IUsingDirectiveSymbol iUsingDirectiveSymbol, int n, int n2, int n3, int n4, List list) {
        super(iContainerSymbol);
        this.using = iUsingDirectiveSymbol;
        this.setStartingOffsetAndLineNumber(n, n2);
        this.setEndingOffsetAndLineNumber(n3, n4);
        this.referenceDelegate = new ASTReferenceStore(list);
    }

    public String getNamespaceName() {
        IASTNamespaceDefinition iASTNamespaceDefinition = this.getNamespaceDefinition();
        String[] stringArray = iASTNamespaceDefinition.getFullyQualifiedName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n + 1 != stringArray.length) {
                stringBuffer.append("::");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
        this.referenceDelegate.processReferences(iSourceElementRequestor);
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() {
        IContainerSymbol iContainerSymbol = this.using.getNamespace();
        return (IASTNamespaceDefinition)((Object)iContainerSymbol.getASTExtension().getPrimaryDeclaration());
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }
}

