/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTScopedTypeSpecifier;

public class ASTEnumerationSpecifier
extends ASTScopedTypeSpecifier
implements IASTEnumerationSpecifier,
IASTOffsetableNamedElement {
    private final String name;
    private NamedOffsets offsets = new NamedOffsets();
    private List enumerators = new ArrayList();

    public ASTEnumerationSpecifier(IASTScope iASTScope, String string, int n, int n2, int n3, int n4, int n5) {
        super(iASTScope, string);
        this.name = string;
        this.offsets.setNameOffset(n3);
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
        this.setNameEndOffsetAndLineNumber(n4, n5);
    }

    public String getName() {
        return this.name;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int n) {
        this.offsets.setNameOffset(n);
    }

    public void setStartingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setStartingOffsetAndLineNumber(n, n2);
    }

    public void setEndingOffsetAndLineNumber(int n, int n2) {
        this.offsets.setEndingOffsetAndLineNumber(n, n2);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public Iterator getEnumerators() {
        return Collections.unmodifiableList(this.enumerators).iterator();
    }

    public void addEnumerator(IASTEnumerator iASTEnumerator) {
        this.enumerators.add(iASTEnumerator);
    }

    public void acceptElement(ISourceElementRequestor iSourceElementRequestor) {
        try {
            iSourceElementRequestor.acceptEnumerationSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public void exitScope(ISourceElementRequestor iSourceElementRequestor) {
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.offsets.setNameEndOffsetAndLineNumber(n, n2);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

