/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IncludeEntry[] sortedIncludes;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex inMemoryIndex) {
        this.index = inMemoryIndex;
    }

    public void clearCache() {
    }

    public void close() throws IOException {
        this.sortedFiles = null;
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    public IndexedFile getIndexedFile(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.sortedFiles.length) {
            if (this.sortedFiles[n2].getFileNumber() == n) {
                return this.sortedFiles[n2];
            }
            ++n2;
        }
        return null;
    }

    public IndexedFile getIndexedFile(IDocument iDocument) throws IOException {
        String string = iDocument.getName();
        int n = this.index.getNumFiles();
        while (n >= 1) {
            IndexedFile indexedFile = this.getIndexedFile(n);
            if (string.equals(indexedFile.getPath())) {
                return indexedFile;
            }
            --n;
        }
        return null;
    }

    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    public int getNumIncludes() {
        return this.sortedIncludes.length;
    }

    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    public void moveToNextFile() throws IOException {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    public void moveToNextWordEntry() throws IOException {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    public void moveToNextIncludeEntry() throws IOException {
        ++this.includePosition;
        if (this.hasMoreIncludes()) {
            this.currentIncludeEntry = this.sortedIncludes[this.includePosition - 1];
        }
    }

    public void open() throws IOException {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.sortedIncludes = this.index.getSortedIncludeEntries();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.includePosition = 1;
        this.setFirstFile();
        this.setFirstWord();
        this.setFirstInclude();
    }

    public IQueryResult[] query(String string) throws IOException {
        char[] cArray = string.toCharArray();
        WordEntry wordEntry = this.index.getWordEntry(cArray);
        int[] nArray = wordEntry.getRefs();
        IQueryResult[] iQueryResultArray = new IQueryResult[nArray.length];
        int n = 0;
        while (n < iQueryResultArray.length) {
            iQueryResultArray[n] = this.getIndexedFile(nArray[n]);
            ++n;
        }
        return iQueryResultArray;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] cArray) throws IOException {
        return null;
    }

    public IQueryResult[] queryFilesReferringToPrefix(char[] cArray) throws IOException {
        return null;
    }

    public IQueryResult[] queryInDocumentNames(String string) throws IOException {
        IQueryResult[] iQueryResultArray;
        this.setFirstFile();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            iQueryResultArray = this.getCurrentFile();
            if (iQueryResultArray.getPath().indexOf(string) != -1) {
                arrayList.add(iQueryResultArray.getPath());
            }
            this.moveToNextFile();
        }
        iQueryResultArray = new IQueryResult[arrayList.size()];
        arrayList.toArray(iQueryResultArray);
        return iQueryResultArray;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }

    protected void setFirstInclude() throws IOException {
        this.includePosition = 1;
        if (this.sortedIncludes.length > 0) {
            this.currentIncludeEntry = this.sortedIncludes[0];
        }
    }

    public IncludeEntry[] queryIncludeEntries() {
        return null;
    }

    public IncludeEntry[] queryIncludeEntries(int n) throws IOException {
        return null;
    }
}

