/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.cdt.internal.core.model.SetPathEntriesOperation;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PathEntryManager {
    static String CONTAINER_INITIALIZER_EXTPOINT_ID = "pathEntryContainerInitializer";
    static String PATH_ENTRY = "pathentry";
    static String PATH_ENTRY_ID = "org.eclipse.cdt.core.pathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_RECUSIVE = "recusive";
    static String ATTRIBUTE_OUTPUT = "output";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String VALUE_TRUE = "true";
    static final IPathEntry[] EMPTY = new IPathEntry[0];
    static final String[] NO_PREREQUISITES = new String[0];
    public static HashMap Containers = new HashMap(5);
    HashMap resolvedMap = new HashMap();
    private static PathEntryManager pathEntryManager;

    private PathEntryManager() {
    }

    public static PathEntryManager getDefault() {
        if (pathEntryManager == null) {
            pathEntryManager = new PathEntryManager();
        }
        return pathEntryManager;
    }

    public IPathEntry[] getResolvedPathEntries(ICProject iCProject) throws CModelException {
        IPathEntry[] iPathEntryArray = (IPathEntry[])this.resolvedMap.get(iCProject);
        if (iPathEntryArray == null) {
            iPathEntryArray = this.getRawPathEntries(iCProject);
            ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>();
            int n = 0;
            while (n < iPathEntryArray.length) {
                IPathEntry iPathEntry = iPathEntryArray[n];
                if (iPathEntry.getEntryKind() == 5) {
                    IPathEntry[] iPathEntryArray2;
                    IContainerEntry iContainerEntry = (IContainerEntry)iPathEntry;
                    IPathEntryContainer iPathEntryContainer = this.getPathEntryContainer(iContainerEntry, iCProject);
                    if (iPathEntryContainer != null && (iPathEntryArray2 = iPathEntryContainer.getPathEntries()) != null) {
                        int n2 = 0;
                        while (n2 < iPathEntryArray2.length) {
                            arrayList.add(iPathEntryArray2[n]);
                            ++n2;
                        }
                    }
                } else {
                    arrayList.add(iPathEntry);
                }
                ++n;
            }
            iPathEntryArray = new IPathEntry[arrayList.size()];
            arrayList.toArray(iPathEntryArray);
            this.resolvedMap.put(iCProject, iPathEntryArray);
        }
        return iPathEntryArray;
    }

    public void setRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        try {
            IPathEntry[] iPathEntryArray2 = (IPathEntry[])this.resolvedMap.get(iCProject);
            this.resolvedMap.put(iCProject, null);
            SetPathEntriesOperation setPathEntriesOperation = new SetPathEntriesOperation(iCProject, iPathEntryArray2, iPathEntryArray);
            CModelManager.getDefault().runOperation(setPathEntriesOperation, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public IPathEntry[] getRawPathEntries(ICProject iCProject) throws CModelException {
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>();
        try {
            ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iCProject.getProject());
            Element element = iCDescriptor.getProjectData(PATH_ENTRY_ID);
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1 && node.getNodeName().equals(PATH_ENTRY)) {
                    arrayList.add(PathEntryManager.decodePathEntry(iCProject, (Element)node));
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        return arrayList.toArray(EMPTY);
    }

    public void setPathEntryContainer(ICProject[] iCProjectArray, IPathEntryContainer iPathEntryContainer, IProgressMonitor iProgressMonitor) throws CModelException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return;
        }
        Path path = iPathEntryContainer == null ? new Path("") : iPathEntryContainer.getPath();
        final int n = iCProjectArray.length;
        final ICProject[] iCProjectArray2 = new ICProject[n];
        System.arraycopy(iCProjectArray, 0, iCProjectArray2, 0, n);
        final IPathEntry[][] iPathEntryArray = new IPathEntry[n][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return;
            }
            ICProject iCProject = iCProjectArray[n3];
            boolean bl = false;
            IPathEntry[] iPathEntryArray2 = this.getRawPathEntries(iCProject);
            int n4 = 0;
            int n5 = iPathEntryArray2.length;
            while (n4 < n5) {
                IContainerEntry iContainerEntry;
                IPathEntry iPathEntry = iPathEntryArray2[n4];
                if (iPathEntry.getEntryKind() == 5 && (iContainerEntry = (IContainerEntry)iPathEntry).getPath().equals((Object)path)) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                iCProjectArray2[n3] = null;
            } else {
                IPathEntryContainer iPathEntryContainer2 = this.containerGet(iCProject, (IPath)path);
                if (iPathEntryContainer2 != null && iPathEntryContainer != null && iPathEntryContainer2.equals(iPathEntryContainer)) {
                    iCProjectArray2[n3] = null;
                } else {
                    ++n2;
                    iPathEntryArray[n3] = (IPathEntry[])this.resolvedMap.get(iCProject);
                    this.resolvedMap.put(iCProject, null);
                    this.containerPut(iCProject, (IPath)path, iPathEntryContainer);
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        try {
            CoreModel.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    boolean bl = false;
                    CModelManager cModelManager = CModelManager.getDefault();
                    int n3 = 0;
                    while (n3 < n) {
                        IPathEntry[] iPathEntryArray2;
                        ICElementDelta[] iCElementDeltaArray;
                        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                            return;
                        }
                        ICProject iCProject = iCProjectArray2[n3];
                        if (iCProject != null && (iCElementDeltaArray = PathEntryManager.this.generatePathEntryDeltas(iCProject, iPathEntryArray[n3], iPathEntryArray2 = PathEntryManager.this.getResolvedPathEntries(iCProject))).length > 0) {
                            bl = true;
                            int n2 = 0;
                            while (n2 < iCElementDeltaArray.length) {
                                cModelManager.registerCModelDelta(iCElementDeltaArray[n2]);
                                ++n2;
                            }
                        }
                        ++n3;
                    }
                    if (bl) {
                        cModelManager.fire(1);
                    }
                }
            }, iProgressMonitor);
        }
        catch (CoreException coreException) {
            if (coreException instanceof CModelException) {
                throw (CModelException)coreException;
            }
            throw new CModelException(coreException);
        }
    }

    public IPathEntryContainer getPathEntryContainer(IContainerEntry iContainerEntry, ICProject iCProject) throws CModelException {
        return this.getPathEntryContainer(iContainerEntry.getPath(), iCProject);
    }

    /*
     * Exception decompiling
     */
    public IPathEntryContainer getPathEntryContainer(IPath var1_1, ICProject var2_2) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 91->94)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PathEntryContainerInitializer getPathEntryContainerInitializer(String string) {
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        if (cCorePlugin == null) {
            return null;
        }
        IExtensionPoint iExtensionPoint = cCorePlugin.getDescriptor().getExtensionPoint(CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string2 = iConfigurationElementArray[n2].getAttribute("id");
                    if (string2 != null && string2.equals(string)) {
                        try {
                            Object object = iConfigurationElementArray[n2].createExecutableExtension("class");
                            if (object instanceof PathEntryContainerInitializer) {
                                return (PathEntryContainerInitializer)object;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    public IPathEntryContainer containerGet(ICProject iCProject, IPath iPath) {
        HashMap hashMap = (HashMap)Containers.get(iCProject);
        if (hashMap == null) {
            hashMap = new HashMap();
            Containers.put(iCProject, hashMap);
        }
        IPathEntryContainer iPathEntryContainer = (IPathEntryContainer)hashMap.get(iPath);
        return iPathEntryContainer;
    }

    public void containerPut(ICProject iCProject, IPath iPath, IPathEntryContainer iPathEntryContainer) {
        HashMap<IPath, IPathEntryContainer> hashMap = (HashMap<IPath, IPathEntryContainer>)Containers.get(iCProject);
        if (hashMap == null) {
            hashMap = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(iCProject, hashMap);
        }
        hashMap.put(iPath, iPathEntryContainer);
    }

    public String[] projectPrerequisites(IPathEntry[] iPathEntryArray) throws CModelException {
        if (iPathEntryArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = iPathEntryArray.length;
            while (n < n2) {
                if (iPathEntryArray[n].getEntryKind() == 2) {
                    IProjectEntry iProjectEntry = (IProjectEntry)iPathEntryArray[n];
                    arrayList.add(iProjectEntry.getPath().lastSegment());
                }
                ++n;
            }
            n = arrayList.size();
            if (n != 0) {
                String[] stringArray = new String[n];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return NO_PREREQUISITES;
    }

    public void saveRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray) throws CModelException {
        try {
            ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iCProject.getProject());
            Element element = iCDescriptor.getProjectData(PATH_ENTRY_ID);
            Node node = element.getFirstChild();
            while (node != null) {
                element.removeChild(node);
                node = element.getFirstChild();
            }
            if (iPathEntryArray != null && iPathEntryArray.length > 0) {
                Document document = element.getOwnerDocument();
                PathEntryManager.encodePathEntries(iCProject.getPath(), document, element, iPathEntryArray);
            }
            iCDescriptor.saveProjectData();
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public ICElementDelta[] generatePathEntryDeltas(ICProject iCProject, IPathEntry[] iPathEntryArray, IPathEntry[] iPathEntryArray2) {
        boolean bl;
        int n;
        ArrayList<ICElementDelta> arrayList = new ArrayList<ICElementDelta>();
        CModelManager.getDefault();
        if (iPathEntryArray != null) {
            n = 0;
            while (n < iPathEntryArray.length) {
                ICElementDelta iCElementDelta;
                bl = false;
                if (iPathEntryArray2 != null) {
                    int n2 = 0;
                    while (n2 < iPathEntryArray2.length) {
                        if (iPathEntryArray[n].equals(iPathEntryArray2[n2])) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl && (iCElementDelta = this.makePathEntryDelta(iCProject, iPathEntryArray[n], true)) != null) {
                    arrayList.add(iCElementDelta);
                }
                ++n;
            }
        }
        if (iPathEntryArray2 != null) {
            n = 0;
            while (n < iPathEntryArray2.length) {
                ICElementDelta iCElementDelta;
                bl = false;
                if (iPathEntryArray != null) {
                    int n3 = 0;
                    while (n3 < iPathEntryArray.length) {
                        if (iPathEntryArray2[n].equals(iPathEntryArray[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!bl && (iCElementDelta = this.makePathEntryDelta(iCProject, iPathEntryArray2[n], false)) != null) {
                    arrayList.add(iCElementDelta);
                }
                ++n;
            }
        }
        ICElementDelta[] iCElementDeltaArray = new ICElementDelta[arrayList.size()];
        arrayList.toArray(iCElementDeltaArray);
        return iCElementDeltaArray;
    }

    protected ICElementDelta makePathEntryDelta(ICProject iCProject, IPathEntry iPathEntry, boolean bl) {
        Object object;
        int n = iPathEntry.getEntryKind();
        ICElement iCElement = null;
        int n2 = 0;
        if (n == 3) {
            object = (ISourceEntry)iPathEntry;
            IPath iPath = object.getPath();
            iCElement = CoreModel.getDefault().create(iPath);
            n2 = bl ? 512 : 256;
        } else if (n == 1) {
            object = (ILibraryEntry)iPathEntry;
            iCElement = CProject.getLibraryReference(iCProject, null, (ILibraryEntry)object);
            n2 = bl ? 4096 : 8192;
        } else if (n == 2) {
            iCElement = iCProject;
            n2 = 16384;
        } else if (n == 4) {
            object = (IIncludeEntry)iPathEntry;
            IPath iPath = object.getPath();
            iCElement = CoreModel.getDefault().create(iPath);
            n2 = 2048;
        } else if (n == 6) {
            object = (IMacroEntry)iPathEntry;
            IPath iPath = object.getPath();
            iCElement = CoreModel.getDefault().create(iPath);
            n2 = 1024;
        }
        if (iCElement == null) {
            iCElement = iCProject;
        }
        object = new CElementDelta(iCProject.getCModel());
        ((CElementDelta)object).changed(iCElement, n2);
        return object;
    }

    static String[] getRegisteredContainerIDs() {
        Object[] objectArray;
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        if (cCorePlugin == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(5);
        IExtensionPoint iExtensionPoint = cCorePlugin.getDescriptor().getExtensionPoint(CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (iExtensionPoint != null) {
            objectArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < objectArray.length) {
                IConfigurationElement[] iConfigurationElementArray = objectArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n2].getAttribute("id");
                    if (string != null) {
                        arrayList.add(string);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    static IPathEntry decodePathEntry(ICProject iCProject, Element element) throws CModelException {
        int n;
        char[][] cArray;
        int n2;
        IPath iPath = iCProject.getProject().getFullPath();
        String string = element.getAttribute(ATTRIBUTE_KIND);
        int n3 = PathEntry.kindFromString(string);
        boolean bl = false;
        if (element.hasAttribute(ATTRIBUTE_EXPORTED)) {
            bl = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        String string2 = element.getAttribute(ATTRIBUTE_PATH);
        Path path = new Path(string2);
        if (n3 != 10 && !path.isAbsolute()) {
            path = iPath.append((IPath)path);
        }
        Path path2 = element.hasAttribute(ATTRIBUTE_SOURCEPATH) ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
        Path path3 = element.hasAttribute(ATTRIBUTE_ROOTPATH) ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
        Path path4 = element.hasAttribute(ATTRIBUTE_PREFIXMAPPING) ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
        String string3 = element.getAttribute(ATTRIBUTE_EXCLUDING);
        IPath[] iPathArray = APathEntry.NO_EXCLUSION_PATTERNS;
        if (!string3.equals("") && (n2 = (cArray = CharOperation.splitOn('|', string3.toCharArray())).length) > 0) {
            iPathArray = new IPath[n2];
            n = 0;
            while (n < cArray.length) {
                iPathArray[n] = new Path(new String(cArray[n]));
                ++n;
            }
        }
        boolean bl2 = false;
        if (element.hasAttribute(ATTRIBUTE_RECUSIVE)) {
            bl2 = element.getAttribute(ATTRIBUTE_RECUSIVE).equals(VALUE_TRUE);
        }
        switch (n3) {
            case 2: {
                return CoreModel.newProjectEntry((IPath)path, bl);
            }
            case 1: {
                return CoreModel.newLibraryEntry((IPath)path, (IPath)path2, (IPath)path3, (IPath)path4, bl);
            }
            case 3: {
                IPath iPath2 = element.hasAttribute(ATTRIBUTE_OUTPUT) ? iPath.append(element.getAttribute(ATTRIBUTE_OUTPUT)) : null;
                String string4 = path.segment(0);
                if (string4 != null && string4.equals(iCProject.getElementName())) {
                    return CoreModel.newSourceEntry((IPath)path, iPath2, bl2, iPathArray);
                }
                return CoreModel.newProjectEntry((IPath)path, bl);
            }
            case 4: {
                Path path5 = element.hasAttribute(ATTRIBUTE_INCLUDE) ? new Path(element.getAttribute(ATTRIBUTE_INCLUDE)) : null;
                n = 0;
                if (element.hasAttribute(ATTRIBUTE_SYSTEM)) {
                    n = element.getAttribute(ATTRIBUTE_SYSTEM).equals(VALUE_TRUE) ? 1 : 0;
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)path5, n != 0, bl2, iPathArray);
            }
            case 6: {
                String string5 = element.getAttribute(ATTRIBUTE_NAME);
                String string6 = element.getAttribute(ATTRIBUTE_VALUE);
                return CoreModel.newMacroEntry((IPath)path, string5, string6, bl2, iPathArray, bl);
            }
            case 5: {
                Path path6 = new Path(element.getAttribute(ATTRIBUTE_PATH));
                return CoreModel.newContainerEntry((IPath)path6, bl);
            }
        }
        CModelStatus cModelStatus = new CModelStatus(4, "PathEntry: unknown kind (" + string + ")");
        throw new CModelException(cModelStatus);
    }

    static void encodePathEntries(IPath iPath, Document document, Element element, IPathEntry[] iPathEntryArray) {
        int n = 0;
        while (n < iPathEntryArray.length) {
            StringBuffer stringBuffer;
            IPath iPath2;
            IPathEntry iPathEntry;
            Element element2 = document.createElement(PATH_ENTRY);
            element.appendChild(element2);
            int n2 = iPathEntryArray[n].getEntryKind();
            element2.setAttribute(ATTRIBUTE_KIND, PathEntry.kindToString(n2));
            if (iPathEntryArray[n] instanceof APathEntry) {
                iPathEntry = (APathEntry)iPathEntryArray[n];
                iPath2 = ((APathEntry)iPathEntry).getExclusionPatterns();
                if (((IPath[])iPath2).length > 0) {
                    stringBuffer = new StringBuffer(10);
                    int n3 = 0;
                    int n4 = ((IPath)iPath2).length;
                    while (n3 < n4) {
                        if (n3 > 0) {
                            stringBuffer.append('|');
                        }
                        stringBuffer.append(iPath2[n3]);
                        ++n3;
                    }
                    element2.setAttribute(ATTRIBUTE_EXCLUDING, stringBuffer.toString());
                }
                if (((APathEntry)iPathEntry).isRecursive()) {
                    element2.setAttribute(ATTRIBUTE_RECUSIVE, VALUE_TRUE);
                }
            }
            if (n2 == 3) {
                iPathEntry = (ISourceEntry)iPathEntryArray[n];
                iPath2 = iPathEntry.getPath();
                element2.setAttribute(ATTRIBUTE_PATH, iPath2.toString());
                stringBuffer = iPathEntry.getOutputLocation();
                if (stringBuffer != null && stringBuffer.isEmpty()) {
                    element2.setAttribute(ATTRIBUTE_OUTPUT, stringBuffer.toString());
                }
            } else if (n2 == 1) {
                iPathEntry = (ILibraryEntry)iPathEntryArray[n];
                iPath2 = iPathEntry.getPath();
                element2.setAttribute(ATTRIBUTE_PATH, iPath2.toString());
                if (iPathEntry.getSourceAttachmentPath() != null) {
                    element2.setAttribute(ATTRIBUTE_SOURCEPATH, iPathEntry.getSourceAttachmentPath().toString());
                }
                if (iPathEntry.getSourceAttachmentRootPath() != null) {
                    element2.setAttribute(ATTRIBUTE_ROOTPATH, iPathEntry.getSourceAttachmentRootPath().toString());
                }
                if (iPathEntry.getSourceAttachmentPrefixMapping() != null) {
                    element2.setAttribute(ATTRIBUTE_PREFIXMAPPING, iPathEntry.getSourceAttachmentPrefixMapping().toString());
                }
            } else if (n2 == 2) {
                iPathEntry = (IProjectEntry)iPathEntryArray[n];
                iPath2 = iPathEntry.getPath();
                element2.setAttribute(ATTRIBUTE_PATH, iPath2.toString());
            } else if (n2 == 4) {
                iPathEntry = (IIncludeEntry)iPathEntryArray[n];
                iPath2 = iPathEntry.getPath();
                element2.setAttribute(ATTRIBUTE_PATH, iPath2.toString());
                stringBuffer = iPathEntry.getIncludePath();
                element2.setAttribute(ATTRIBUTE_INCLUDE, stringBuffer.toString());
                if (iPathEntry.isSystemInclude()) {
                    element2.setAttribute(ATTRIBUTE_SYSTEM, VALUE_TRUE);
                }
            } else if (n2 == 6) {
                iPathEntry = (IMacroEntry)iPathEntryArray[n];
                iPath2 = iPathEntry.getPath();
                element2.setAttribute(ATTRIBUTE_PATH, iPath2.toString());
                element2.setAttribute(ATTRIBUTE_NAME, iPathEntry.getMacroName());
                element2.setAttribute(ATTRIBUTE_VALUE, iPathEntry.getMacroValue());
            } else if (n2 == 5) {
                iPathEntry = (IContainerEntry)iPathEntryArray[n];
                element2.setAttribute(ATTRIBUTE_PATH, iPathEntry.getPath().toString());
            }
            if (iPathEntryArray[n].isExported()) {
                element2.setAttribute(ATTRIBUTE_EXPORTED, VALUE_TRUE);
            }
            ++n;
        }
    }
}

