/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class MethodDeclarationPattern
extends CSearchPattern {
    private ICSearchConstants.SearchFor searchFor;
    private char[][] parameterNames;
    private char[] simpleName;
    private char[][] qualifications;
    private char[] decodedSimpleName;
    private char[][] decodedQualifications;

    public MethodDeclarationPattern(char[] cArray, char[][] cArray2, char[][] cArray3, int n, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, boolean bl) {
        super(n, bl, limitTo);
        this.qualifications = cArray2;
        this.simpleName = cArray;
        this.parameterNames = cArray3;
        this.searchFor = searchFor;
    }

    public char[] getSimpleName() {
        return this.simpleName;
    }

    public int matchLevel(ISourceElementCallbackDelegate iSourceElementCallbackDelegate, ICSearchConstants.LimitTo limitTo) {
        Object object;
        if (iSourceElementCallbackDelegate instanceof IASTMethod) {
            if (this.searchFor != ICSearchConstants.METHOD || !this.canAccept(limitTo)) {
                return 0;
            }
        } else if (iSourceElementCallbackDelegate instanceof IASTFunction) {
            if (this.searchFor != ICSearchConstants.FUNCTION || !this.canAccept(limitTo)) {
                return 0;
            }
        } else {
            return 0;
        }
        IASTFunction iASTFunction = (IASTFunction)iSourceElementCallbackDelegate;
        String string = iASTFunction.getName();
        if (this.simpleName != null && !this.matchesName(this.simpleName, string.toCharArray())) {
            return 0;
        }
        if (iSourceElementCallbackDelegate instanceof IASTQualifiedNameElement) {
            object = ((IASTQualifiedNameElement)iSourceElementCallbackDelegate).getFullyQualifiedName();
            char[][] cArray = new char[((String[])object).length - 1][];
            int n = 0;
            while (n < ((String[])object).length - 1) {
                cArray[n] = ((String)object[n]).toCharArray();
                ++n;
            }
            if (!this.matchQualifications(this.qualifications, cArray)) {
                return 0;
            }
        }
        if (this.parameterNames != null && this.parameterNames.length > 0 && this.parameterNames[0].length > 0) {
            object = iASTFunction.getParameters();
            if (!object.hasNext() && CharOperation.equals(this.parameterNames[0], "void ".toCharArray())) {
                return 2;
            }
            int n = 0;
            while (n < this.parameterNames.length) {
                if (!object.hasNext() || this.parameterNames[n] == null) {
                    return 0;
                }
                IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)object.next();
                char[] cArray = CSearchPattern.getParamString(iASTParameterDeclaration);
                if (!CharOperation.equals(this.parameterNames[n], cArray, this._caseSensitive)) {
                    return 0;
                }
                ++n;
            }
            if (object.hasNext()) {
                return 0;
            }
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == ICSearchConstants.FUNCTION) {
            return AbstractIndexer.bestFunctionPrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.METHOD) {
            return AbstractIndexer.bestMethodPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult iEntryResult) {
        char[] cArray = iEntryResult.getWord();
        int n = cArray.length;
        int n2 = CharOperation.indexOf('/', cArray, 0);
        int n3 = CharOperation.indexOf('/', cArray, n2 + 1);
        this.decodedSimpleName = CharOperation.subarray(cArray, n2 + 1, n3);
        if (n3 != -1 && n3 + 1 < n) {
            char[][] cArray2 = CharOperation.splitOn('/', CharOperation.subarray(cArray, n3 + 1, n));
            this.decodedQualifications = new char[cArray2.length][];
            int n4 = 0;
            while (n4 < cArray2.length) {
                this.decodedQualifications[n4] = cArray2[cArray2.length - n4 - 1];
                ++n4;
            }
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedQualifications);
    }

    public void feedIndexRequestor(IIndexSearchRequestor iIndexSearchRequestor, int n, int[] nArray, IndexInput indexInput, ICSearchScope iCSearchScope) throws IOException {
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            String string;
            IndexedFile indexedFile = indexInput.getIndexedFile(nArray[n2]);
            if (indexedFile != null && iCSearchScope.encloses(string = indexedFile.getPath())) {
                if (this.searchFor == ICSearchConstants.METHOD) {
                    iIndexSearchRequestor.acceptMethodDeclaration(string, this.decodedSimpleName, this.parameterNames.length, this.decodedQualifications);
                } else if (this.searchFor == ICSearchConstants.FUNCTION) {
                    iIndexSearchRequestor.acceptFunctionDeclaration(string, this.decodedSimpleName, this.parameterNames.length);
                }
            }
            ++n2;
        }
    }
}

