/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class DependencyQueryJob
implements IJob {
    IProject project;
    IFile file;
    ArrayList includeFiles;
    IndexManager indexManager;
    protected IndexSelector indexSelector;
    protected long executionTime = 0L;

    public DependencyQueryJob(IProject iProject, IFile iFile, IndexManager indexManager, List list) {
        this.project = iProject;
        this.file = iFile;
        this.indexManager = indexManager;
        this.includeFiles = (ArrayList)list;
    }

    public boolean belongsTo(String string) {
        return true;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block10: {
            if (this.project == null || this.file == null) {
                return false;
            }
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean bl2 = true;
            this.executionTime = 0L;
            if (this.indexSelector == null) {
                this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
            }
            IIndex[] iIndexArray = this.indexSelector.getIndexes();
            try {
                int n = iIndexArray.length;
                if (iProgressMonitor != null) {
                    iProgressMonitor.beginTask("", n);
                }
                int n2 = 0;
                while (n2 < n) {
                    bl2 &= this.getFileDeps(iIndexArray[n2], iProgressMonitor);
                    if (iProgressMonitor != null) {
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iProgressMonitor.worked(1);
                    }
                    ++n2;
                }
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
                }
                bl = bl2;
                Object var6_7 = null;
                if (iProgressMonitor == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var6_8 = null;
                    if (iProgressMonitor == null) break block11;
                    iProgressMonitor.done();
                }
                throw throwable;
            }
            iProgressMonitor.done();
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFileDeps(IIndex iIndex, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (iIndex == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = this.indexManager.getMonitorFor(iIndex);
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                block15: {
                    readWriteMonitor.enterRead();
                    if (!iIndex.hasChanged()) break block15;
                    try {
                        try {
                            readWriteMonitor.exitRead();
                            readWriteMonitor.enterWrite();
                            this.indexManager.saveIndex(iIndex);
                        }
                        catch (IOException iOException) {
                            Object var4_4 = null;
                            readWriteMonitor.exitWriteEnterRead();
                            Object var9_8 = null;
                            readWriteMonitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        readWriteMonitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                        readWriteMonitor.exitWriteEnterRead();
                    }
                }
                long l = System.currentTimeMillis();
                BlocksIndexInput blocksIndexInput = new BlocksIndexInput(iIndex.getIndexFile());
                try {
                    ((IndexInput)blocksIndexInput).open();
                    this.findDep(blocksIndexInput);
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    ((IndexInput)blocksIndexInput).close();
                    throw throwable;
                }
                {
                    Object var7_16 = null;
                }
                ((IndexInput)blocksIndexInput).close();
                this.executionTime += System.currentTimeMillis() - l;
                Object var9_9 = null;
                readWriteMonitor.exitRead();
                return true;
            }
            catch (IOException iOException) {
                Object var9_10 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
    }

    private void findDep(IndexInput indexInput) throws IOException {
        IFileDocument iFileDocument = new IFileDocument(this.file);
        IndexedFile indexedFile = indexInput.getIndexedFile(iFileDocument);
        if (indexedFile == null) {
            return;
        }
        int n = indexedFile.getFileNumber();
        IncludeEntry[] includeEntryArray = indexInput.queryIncludeEntries(n);
        if (includeEntryArray != null) {
            int n2 = 0;
            while (n2 < includeEntryArray.length) {
                char[] cArray = includeEntryArray[n2].getFile();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray);
                this.includeFiles.add(stringBuffer.toString());
                ++n2;
            }
        }
    }

    public String toString() {
        return "searching for the dependencies of" + this.file.getName();
    }

    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }
}

