/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.elf.ERandomAccessFile;
import org.eclipse.cdt.utils.elf.Elf;

public class AR {
    protected String filename;
    protected ERandomAccessFile efile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] byArray) {
        return byArray.length >= 7 && byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62;
    }

    public AR(String string) throws IOException {
        this.filename = string;
        this.efile = new ERandomAccessFile(string, "r");
        String string2 = this.efile.readLine();
        if (string2 == null || string2.compareTo("!<arch>") != 0) {
            this.efile.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> vector = new Vector<ARHeader>();
        try {
            while (this.efile.getFilePointer() < this.efile.length()) {
                ARHeader aRHeader = new ARHeader();
                String string = aRHeader.getObjectName();
                long l = this.efile.getFilePointer();
                if (string.charAt(0) != '/') {
                    vector.add(aRHeader);
                }
                if (string.compareTo("//") == 0) {
                    this.strtbl_pos = l;
                }
                if ((l += aRHeader.getSize()) % 2L != 0L) {
                    ++l;
                }
                this.efile.seek(l);
            }
        }
        catch (IOException iOException) {}
        this.headers = vector.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] extractFiles(String string, String[] stringArray) throws IOException {
        Vector<String> vector = new Vector<String>();
        this.loadHeaders();
        int n = 0;
        int n2 = 0;
        while (n2 < this.headers.length) {
            String string2 = this.headers[n2].getObjectName();
            if (stringArray == null || this.stringInStrings(string2, stringArray)) {
                string2 = n + "_" + string2;
                ++n;
                byte[] byArray = this.headers[n2].getObjectData();
                File file = new File(string, string2);
                vector.add(string2);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    public String[] extractFiles(String string) throws IOException {
        return this.extractFiles(string, null);
    }

    public class ARHeader {
        private String object_name;
        private String modification_time;
        private String uid;
        private String gid;
        private String mode;
        private long size;
        private long elf_offset;

        private String removeBlanks(String string) {
            while (string.charAt(string.length() - 1) == ' ') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String nameFromStringTable(long l) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(0);
            long l2 = AR.this.efile.getFilePointer();
            try {
                if (AR.this.strtbl_pos != -1L) {
                    byte by;
                    AR.this.efile.seek(AR.this.strtbl_pos + l);
                    while ((by = AR.this.efile.readByte()) != 10) {
                        stringBuffer.append((char)by);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                AR.this.efile.seek(l2);
                throw throwable;
            }
            {
                Object var7_7 = null;
            }
            AR.this.efile.seek(l2);
            return stringBuffer.toString();
        }

        public ARHeader() throws IOException {
            int n;
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[12];
            byte[] byArray3 = new byte[6];
            byte[] byArray4 = new byte[6];
            byte[] byArray5 = new byte[8];
            byte[] byArray6 = new byte[10];
            byte[] byArray7 = new byte[2];
            AR.this.efile.read(byArray);
            AR.this.efile.read(byArray2);
            AR.this.efile.read(byArray3);
            AR.this.efile.read(byArray4);
            AR.this.efile.read(byArray5);
            AR.this.efile.read(byArray6);
            AR.this.efile.read(byArray7);
            this.elf_offset = AR.this.efile.getFilePointer();
            this.object_name = this.removeBlanks(new String(byArray));
            this.modification_time = new String(byArray2);
            this.uid = new String(byArray3);
            this.gid = new String(byArray4);
            this.mode = new String(byArray5);
            this.size = Long.parseLong(this.removeBlanks(new String(byArray6)));
            if (AR.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long l = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(l);
                }
                catch (Exception exception) {}
            }
            if ((n = this.object_name.length()) > 2 && this.object_name.charAt(n - 1) == '/') {
                this.object_name = this.object_name.substring(0, n - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public Elf getElf() throws IOException {
            return new Elf(AR.this.filename, this.elf_offset);
        }

        public Elf getElf(boolean bl) throws IOException {
            return new Elf(AR.this.filename, this.elf_offset, bl);
        }

        public byte[] getObjectData() throws IOException {
            byte[] byArray = new byte[(int)this.size];
            if (AR.this.efile != null) {
                AR.this.efile.seek(this.elf_offset);
                AR.this.efile.read(byArray);
            } else {
                AR.this.efile = new ERandomAccessFile(AR.this.filename, "r");
                AR.this.efile.seek(this.elf_offset);
                AR.this.efile.read(byArray);
                AR.this.efile.close();
                AR.this.efile = null;
            }
            return byArray;
        }
    }
}

