/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

public class GDBTypeParser {
    static final int EOF = -1;
    static final int NAME = 0;
    static final int PARENS = 1;
    static final int BRACKETS = 2;
    String line;
    int index;
    int tokenType;
    String token;
    String dataType;
    String name;
    GDBDerivedType gdbDerivedType;
    GDBType genericType;

    public GDBType getGDBType() {
        if (this.gdbDerivedType != null) {
            return this.gdbDerivedType;
        }
        return this.genericType;
    }

    public String getVariableName() {
        return this.name;
    }

    public GDBType parse(String string) {
        if (string == null) {
            string = new String();
        }
        this.line = string = string.trim();
        this.index = 0;
        this.token = "";
        this.dataType = "";
        this.name = "";
        this.gdbDerivedType = null;
        while (this.getToken() == 0) {
            this.dataType = String.valueOf(this.dataType) + " " + this.token;
        }
        int n = this.dataType.indexOf(58);
        if (n > 0) {
            this.dataType = this.dataType.substring(0, n);
        }
        this.genericType = new GDBType(this.dataType);
        this.dcl(this.tokenType);
        return this.getGDBType();
    }

    int getch() {
        if (this.index >= this.line.length() || this.index < 0) {
            return -1;
        }
        return this.line.charAt(this.index++);
    }

    void ungetch() {
        if (this.index > 0) {
            --this.index;
        }
    }

    boolean isCIdentifierStart(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 95 || n == 58 || n == 44;
    }

    boolean isCIdentifierPart(int n) {
        return n >= 48 && n <= 9 || n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 95;
    }

    boolean isCSpace(int n) {
        return n == 32 || n == 9 || n == 12 || n == 10;
    }

    void prependChild(int n) {
        this.prependChild(n, 0);
    }

    void prependChild(int n, int n2) {
        this.gdbDerivedType = this.gdbDerivedType == null ? new GDBDerivedType(this.genericType, n, n2) : new GDBDerivedType(this.gdbDerivedType, n, n2);
    }

    int getToken() {
        this.token = "";
        int n = this.getch();
        while (this.isCSpace(n)) {
            n = this.getch();
        }
        if (n == 40) {
            n = this.getch();
            if (n == 41) {
                this.token = "()";
                this.tokenType = 1;
            } else {
                this.ungetch();
                this.tokenType = 40;
            }
        } else if (n == 91) {
            while ((n = this.getch()) != 93 && n != -1) {
                this.token = String.valueOf(this.token) + (char)n;
            }
            this.tokenType = 2;
        } else if (this.isCIdentifierStart(n)) {
            this.token = "" + (char)n;
            while (this.isCIdentifierPart(n = this.getch()) && n != -1) {
                this.token = String.valueOf(this.token) + (char)n;
            }
            if (n != -1) {
                this.ungetch();
            }
            this.tokenType = 0;
        } else if (n == 123) {
            int n2 = 1;
            do {
                if ((n = this.getch()) == 123) {
                    ++n2;
                    continue;
                }
                if (n != 125) continue;
                --n2;
            } while (n2 > 0 && n != -1);
        } else {
            this.tokenType = n;
        }
        return this.tokenType;
    }

    void dcl() {
        this.dcl(this.getToken());
    }

    void dcl(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n == 42) {
            ++n2;
            while (this.getToken() == 42) {
                ++n2;
            }
        } else if (n == 38) {
            ++n3;
            while (this.getToken() == 38) {
                ++n3;
            }
        }
        this.dirdcl();
        while (n2-- > 0) {
            this.prependChild(1);
        }
        while (n3-- > 0) {
            this.prependChild(2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dirdcl() {
        int n;
        int n2;
        if (this.tokenType == 40) {
            this.dcl();
            if (this.tokenType != 41) {
                return;
            }
        } else if (this.tokenType == 0) {
            this.name = " " + this.token;
        } else if (this.tokenType == 1) {
            this.prependChild(4);
        } else {
            if (this.tokenType != 2) {
                return;
            }
            n2 = 0;
            if (this.token.length() > 0) {
                try {
                    n2 = Integer.parseInt(this.token);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.prependChild(3, n2);
        }
        while ((n = this.getToken()) == 1 || n == 2) {
            if (n == -1) {
                return;
            }
            if (n == 1) {
                this.prependChild(4);
                continue;
            }
            n2 = 0;
            if (this.token.length() > 0) {
                try {
                    n2 = Integer.parseInt(this.token);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.prependChild(3, n2);
        }
    }

    public static void main(String[] stringArray) {
        GDBTypeParser gDBTypeParser = new GDBTypeParser();
        System.out.println("struct link { int i; int j; struct link * next} *");
        gDBTypeParser.parse("struct link { int i; int j; struct link * next} *");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("char **argv");
        gDBTypeParser.parse("unsigned long long int **argv");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("int (*daytab)[13]");
        gDBTypeParser.parse("int (*daytab)[13]");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("int *daytab[13]");
        gDBTypeParser.parse("int *daytab[13]");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("void *comp()");
        gDBTypeParser.parse("void *comp()");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("void (*comp)()");
        gDBTypeParser.parse("void (*comp)()");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("int (*func[15])()");
        gDBTypeParser.parse("int (*func[15])()");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("char (*(*x())[])()");
        gDBTypeParser.parse("char (*(*x())[])()");
        System.out.println(gDBTypeParser.getGDBType().verbose());
        System.out.println("char (*(*x[3])())[5]");
        gDBTypeParser.parse("char (*(*x[3])())[5]");
        System.out.println(gDBTypeParser.getGDBType().verbose());
    }

    public class GDBType {
        public static final int GENERIC = 0;
        public static final int POINTER = 1;
        public static final int REFERENCE = 2;
        public static final int ARRAY = 3;
        public static final int FUNCTION = 4;
        String nameType;
        int type;

        public GDBType(String string) {
            this(string, 0);
        }

        public GDBType(int n) {
            this("", n);
        }

        GDBType(String string, int n) {
            this.nameType = string;
            this.type = n;
        }

        public String toString() {
            return this.nameType;
        }

        public String verbose() {
            return this.nameType;
        }

        public int getType() {
            return this.type;
        }
    }

    public class GDBDerivedType
    extends GDBType {
        int dimension;
        GDBType child;

        public GDBDerivedType(GDBType gDBType, int n) {
            this(gDBType, n, 0);
        }

        public GDBDerivedType(GDBType gDBType, int n, int n2) {
            super(n);
            this.setChild(gDBType);
            this.dimension = n2;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setChild(GDBType gDBType) {
            this.child = gDBType;
        }

        public GDBType getChild() {
            return this.child;
        }

        public boolean hasChild() {
            return this.child != null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.hasChild() ? this.child.toString() : "";
            stringBuffer.append(string);
            switch (this.getType()) {
                case 4: {
                    stringBuffer.append("()");
                    break;
                }
                case 3: {
                    stringBuffer.append("[" + this.dimension + "]");
                    break;
                }
                case 2: {
                    stringBuffer.append("&");
                    break;
                }
                case 1: {
                    stringBuffer.append("*");
                }
            }
            return stringBuffer.toString();
        }

        public String verbose() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.getType()) {
                case 4: {
                    stringBuffer.append(" function returning " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 3: {
                    stringBuffer.append(" array[" + this.dimension + "]" + " of " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 2: {
                    stringBuffer.append(" reference to " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 1: {
                    stringBuffer.append(" pointer to " + (this.hasChild() ? this.child.verbose() : ""));
                }
            }
            return stringBuffer.toString();
        }
    }
}

