/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Signal;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIHandle;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSignals;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSignalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MISigHandle;

public class SignalManager
extends SessionObject
implements ICDISignalManager {
    boolean autoupdate = false;
    MISigHandle[] noSigs = new MISigHandle[0];
    List signalsList = null;

    public SignalManager(Session session) {
        super(session);
    }

    MISigHandle[] getMISignals() throws CDIException {
        MISigHandle[] mISigHandleArray = this.noSigs;
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIInfoSignals mIInfoSignals = commandFactory.createMIInfoSignals();
        try {
            mISession.postCommand(mIInfoSignals);
            MIInfoSignalsInfo mIInfoSignalsInfo = mIInfoSignals.getMIInfoSignalsInfo();
            if (mIInfoSignalsInfo == null) {
                throw new CDIException("No answer");
            }
            mISigHandleArray = mIInfoSignalsInfo.getMISignals();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return mISigHandleArray;
    }

    MISigHandle getMISignal(String string) throws CDIException {
        MISigHandle mISigHandle = null;
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        MIInfoSignals mIInfoSignals = commandFactory.createMIInfoSignals(string);
        try {
            mISession.postCommand(mIInfoSignals);
            MIInfoSignalsInfo mIInfoSignalsInfo = mIInfoSignals.getMIInfoSignalsInfo();
            if (mIInfoSignalsInfo == null) {
                throw new CDIException("No answer");
            }
            MISigHandle[] mISigHandleArray = mIInfoSignalsInfo.getMISignals();
            if (mISigHandleArray.length > 0) {
                mISigHandle = mISigHandleArray[0];
            }
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        return mISigHandle;
    }

    private boolean hasSignalChanged(ICDISignal iCDISignal, MISigHandle mISigHandle) {
        return !iCDISignal.getName().equals(mISigHandle.getName()) || iCDISignal.isStopSet() != mISigHandle.isStop() || iCDISignal.isIgnore() != !mISigHandle.isPass();
    }

    public ICDISignal findSignal(String string) {
        ICDISignal iCDISignal = null;
        if (this.signalsList != null) {
            ICDISignal[] iCDISignalArray = this.signalsList.toArray(new ICDISignal[0]);
            int n = 0;
            while (n < iCDISignalArray.length) {
                if (iCDISignalArray[n].getName().equals(string)) {
                    iCDISignal = iCDISignalArray[n];
                    break;
                }
                ++n;
            }
        }
        return iCDISignal;
    }

    public ICDISignal getSignal(String string) {
        ICDISignal iCDISignal = this.findSignal(string);
        if (iCDISignal == null) {
            MISigHandle mISigHandle = null;
            try {
                mISigHandle = this.getMISignal(string);
                iCDISignal = new Signal(this, mISigHandle);
                if (this.signalsList != null) {
                    this.signalsList.add(iCDISignal);
                }
            }
            catch (CDIException cDIException) {
                mISigHandle = new MISigHandle(string, false, false, false, string);
                iCDISignal = new Signal(this, mISigHandle);
            }
        }
        return iCDISignal;
    }

    public void handle(ICDISignal iCDISignal, boolean bl, boolean bl2) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mISession = session.getMISession();
        CommandFactory commandFactory = mISession.getCommandFactory();
        StringBuffer stringBuffer = new StringBuffer(iCDISignal.getName());
        stringBuffer.append(" ");
        if (bl) {
            stringBuffer.append("ignore");
        } else {
            stringBuffer.append("noignore");
        }
        stringBuffer.append(" ");
        if (bl2) {
            stringBuffer.append("stop");
        } else {
            stringBuffer.append("nostop");
        }
        MIHandle mIHandle = commandFactory.createMIHandle(stringBuffer.toString());
        try {
            mISession.postCommand(mIHandle);
            mIHandle.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
        ((Signal)iCDISignal).getMISignal().handle(bl, bl2);
        mISession.fireEvent(new MISignalChangedEvent(iCDISignal.getName()));
    }

    public ICDISignal[] getSignals() throws CDIException {
        if (this.signalsList == null) {
            this.update();
        }
        return this.signalsList.toArray(new ICDISignal[0]);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }

    public void update() throws CDIException {
        MIEvent[] mIEventArray;
        Session session = (Session)this.getSession();
        MISigHandle[] mISigHandleArray = this.getMISignals();
        ArrayList<MISignalChangedEvent> arrayList = new ArrayList<MISignalChangedEvent>(mISigHandleArray.length);
        if (this.signalsList == null) {
            this.signalsList = Collections.synchronizedList(new ArrayList(5));
        }
        int n = 0;
        while (n < mISigHandleArray.length) {
            mIEventArray = this.findSignal(mISigHandleArray[n].getName());
            if (mIEventArray != null) {
                if (this.hasSignalChanged((ICDISignal)mIEventArray, mISigHandleArray[n])) {
                    ((Signal)mIEventArray).setMISignal(mISigHandleArray[n]);
                    arrayList.add(new MISignalChangedEvent(mISigHandleArray[n].getName()));
                }
            } else {
                this.signalsList.add(new Signal(this, mISigHandleArray[n]));
            }
            ++n;
        }
        MISession mISession = session.getMISession();
        mIEventArray = arrayList.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }
}

