/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;

public class DestroyedEvent
implements ICDIDestroyedEvent {
    Session session;
    ICDIObject source;

    public DestroyedEvent(Session session, MIThreadExitEvent mIThreadExitEvent) {
        this.session = session;
        this.source = new Thread(this.session.getCurrentTarget(), mIThreadExitEvent.getId());
    }

    public DestroyedEvent(Session session, MIVarDeletedEvent mIVarDeletedEvent) {
        this.session = session;
        VariableManager variableManager = (VariableManager)this.session.getVariableManager();
        String string = mIVarDeletedEvent.getVarName();
        Variable variable = variableManager.getVariable(string);
        if (variable != null) {
            this.source = variable;
            try {
                variableManager.removeVariable(variable.getMIVar().getVarName());
            }
            catch (CDIException cDIException) {}
        } else {
            ExpressionManager expressionManager = (ExpressionManager)this.session.getExpressionManager();
            variable = expressionManager.getExpression(string);
            if (variable != null) {
                this.source = variable;
                try {
                    expressionManager.removeExpression(variable.getMIVar().getVarName());
                }
                catch (CDIException cDIException) {}
            } else {
                this.source = new CObject(this.session.getCurrentTarget());
            }
        }
    }

    public DestroyedEvent(Session session, MIBreakpointDeletedEvent mIBreakpointDeletedEvent) {
        this.session = session;
        BreakpointManager breakpointManager = (BreakpointManager)this.session.getBreakpointManager();
        int n = mIBreakpointDeletedEvent.getNumber();
        Breakpoint breakpoint = breakpointManager.getBreakpoint(n);
        if (breakpoint != null) {
            this.source = breakpoint;
            breakpointManager.deleteBreakpoint(n);
        } else {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public DestroyedEvent(Session session, MISharedLibUnloadedEvent mISharedLibUnloadedEvent) {
        this.session = session;
        SharedLibraryManager sharedLibraryManager = (SharedLibraryManager)this.session.getSharedLibraryManager();
        String string = mISharedLibUnloadedEvent.getName();
        ICDISharedLibrary iCDISharedLibrary = sharedLibraryManager.getSharedLibrary(string);
        if (iCDISharedLibrary != null) {
            sharedLibraryManager.deleteSharedLibrary(iCDISharedLibrary);
            this.source = iCDISharedLibrary;
        } else {
            this.source = new CObject(this.session.getCurrentTarget());
        }
    }

    public DestroyedEvent(Session session, ICDIObject iCDIObject) {
        this.session = session;
        this.source = iCDIObject;
    }

    public DestroyedEvent(Session session) {
        this.session = session;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

