/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIStoppedEvent
extends MIEvent {
    private int threadId;
    private MIFrame frame;
    private MIExecAsyncOutput exec;
    private MIResultRecord rr;

    public MIStoppedEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput.getToken());
        this.exec = mIExecAsyncOutput;
        this.parse();
    }

    public MIStoppedEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord.getToken());
        this.rr = mIResultRecord;
        this.parse();
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int n) {
        this.threadId = n;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    public void setFrame(MIFrame mIFrame) {
        this.frame = mIFrame;
    }

    public MIExecAsyncOutput getMIExecAsyncOutput() {
        return this.exec;
    }

    public MIResultRecord getMIResultRecord() {
        return this.rr;
    }

    void parse() {
        MIResult[] mIResultArray = null;
        if (this.exec != null) {
            mIResultArray = this.exec.getMIResults();
        } else if (this.rr != null) {
            mIResultArray = this.rr.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                if (string.equals("thread-id")) {
                    if (mIValue instanceof MIConst) {
                        String string2 = ((MIConst)mIValue).getString();
                        try {
                            this.threadId = Integer.parseInt(string2.trim());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string.equals("frame") && mIValue instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)mIValue);
                }
                ++n;
            }
        }
    }
}

