/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIDataReadMemoryInfo
extends MIInfo {
    long addr;
    long nextRow;
    long prevRow;
    long nextPage;
    long prevPage;
    long numBytes;
    long totalBytes;
    MIMemory[] memories;

    public MIDataReadMemoryInfo(MIOutput mIOutput) {
        super(mIOutput);
        this.parse();
    }

    public long getAddress() {
        return this.addr;
    }

    public long getNumberBytes() {
        return this.numBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getNextRow() {
        return this.nextRow;
    }

    public long getPreviousRow() {
        return this.prevRow;
    }

    public long getNextPage() {
        return this.nextPage;
    }

    public long getPreviousPage() {
        return this.prevPage;
    }

    public MIMemory[] getMemories() {
        return this.memories;
    }

    void parse() {
        MIOutput mIOutput;
        MIResultRecord mIResultRecord;
        if (this.isDone() && (mIResultRecord = (mIOutput = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] mIResultArray = mIResultRecord.getMIResults();
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                String string2 = "";
                if (mIValue != null && mIValue instanceof MIConst) {
                    string2 = ((MIConst)mIValue).getCString();
                }
                if (string.equals("addr")) {
                    try {
                        this.addr = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("nr-bytes")) {
                    try {
                        this.numBytes = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("total-bytes")) {
                    try {
                        this.totalBytes = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("next-row")) {
                    try {
                        this.nextRow = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("prev-row")) {
                    try {
                        this.prevRow = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("next-page")) {
                    try {
                        this.nextPage = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("prev-page")) {
                    try {
                        this.prevPage = Long.decode(string2.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("memory") && mIValue instanceof MIList) {
                    this.parseMemory((MIList)mIValue);
                }
                ++n;
            }
        }
        if (this.memories == null) {
            this.memories = new MIMemory[0];
        }
    }

    void parseMemory(MIList mIList) {
        MIValue[] mIValueArray = mIList.getMIValues();
        this.memories = new MIMemory[mIValueArray.length];
        int n = 0;
        while (n < mIValueArray.length) {
            if (mIValueArray[n] instanceof MITuple) {
                this.memories[n] = new MIMemory((MITuple)mIValueArray[n]);
            }
            ++n;
        }
    }
}

