/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIShared;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoSharedLibraryInfo
extends MIInfo {
    MIShared[] shared;
    boolean isUnixFormat = true;
    boolean hasProcessHeader = false;

    public MIInfoSharedLibraryInfo(MIOutput mIOutput) {
        super(mIOutput);
        this.parse();
    }

    public MIShared[] getMIShared() {
        return this.shared;
    }

    void parse() {
        ArrayList arrayList = new ArrayList();
        if (this.isDone()) {
            MIOutput mIOutput = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = mIOutput.getMIOOBRecords();
            int n = 0;
            while (n < mIOOBRecordArray.length) {
                if (mIOOBRecordArray[n] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord mIStreamRecord = (MIStreamRecord)mIOOBRecordArray[n];
                    String string = mIStreamRecord.getString();
                    this.parseShared(string.trim(), arrayList);
                }
                ++n;
            }
        }
        this.shared = new MIShared[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            this.shared[n] = (MIShared)arrayList.get(n);
            ++n;
        }
    }

    void parseShared(String string, List list) {
        if (!this.hasProcessHeader) {
            if (string.startsWith("DLL")) {
                this.isUnixFormat = false;
            }
            this.hasProcessHeader = true;
        } else if (this.isUnixFormat) {
            this.parseUnixShared(string, list);
        } else {
            this.parseWinShared(string, list);
        }
    }

    void parseUnixShared(String string, List list) {
        if (string.length() > 0) {
            int n = -1;
            long l = 0L;
            long l2 = 0L;
            boolean bl = false;
            String string2 = "";
            int n2 = 0;
            while ((n = string.lastIndexOf(32)) != -1 || n2 <= 3) {
                if (n == -1) {
                    n = 0;
                }
                String string3 = string.substring(n).trim();
                string = string.substring(0, n).trim();
                switch (n2) {
                    case 0: {
                        string2 = string3;
                        break;
                    }
                    case 1: {
                        if (!string3.equalsIgnoreCase("Yes")) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        try {
                            l2 = Long.decode(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case 3: {
                        try {
                            l = Long.decode(string3);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                ++n2;
            }
            if (string2.length() > 0) {
                MIShared mIShared = new MIShared(l, l2, bl, string2);
                list.add(mIShared);
            }
        }
    }

    void parseWinShared(String string, List list) {
        Object object;
        long l = 0L;
        long l2 = 0L;
        boolean bl = true;
        int n = string.lastIndexOf(32);
        if (n > 0) {
            object = string.substring(n).trim();
            if (!((String)object).startsWith("0x")) {
                object = "0x" + (String)object;
            }
            try {
                l = Long.decode((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
            string = string.substring(0, n).trim();
        }
        object = new MIShared(l, l2, bl, string.trim());
        list.add(object);
    }
}

