/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.DeclarationWrapper;
import org.eclipse.cdt.internal.core.parser.IDeclarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.parser.IParameterCollection;

public class Declarator
implements IParameterCollection,
IDeclaratorOwner,
IDeclarator {
    private boolean hasFunctionTryBlock;
    private ITokenDuple pointerOperatorNameDuple;
    private ITokenDuple namedDuple;
    private boolean isFunction;
    private boolean hasFunctionBody;
    private IASTExpression constructorExpression;
    private boolean pureVirtual = false;
    private final IDeclaratorOwner owner;
    private Declarator ownedDeclarator = null;
    private String name = "";
    private IASTInitializerClause initializerClause = null;
    private List ptrOps = new ArrayList();
    private List parameters = new ArrayList();
    private List arrayModifiers = new ArrayList();
    private List constructorMemberInitializers = new ArrayList();
    private IASTExceptionSpecification exceptionSpecification = null;
    private IASTExpression bitFieldExpression = null;
    private boolean isConst = false;
    private boolean isVolatile = false;
    private boolean isKandR = false;
    private int nameStartOffset;
    private int nameEndOffset;
    private boolean varArgs;
    private int nameLine;

    public Declarator(IDeclaratorOwner iDeclaratorOwner) {
        this.owner = iDeclaratorOwner;
    }

    public String getName() {
        return this.name;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public int getNameLine() {
        return this.nameLine;
    }

    public int getNameStartOffset() {
        return this.nameStartOffset;
    }

    public IDeclaratorOwner getOwner() {
        return this.owner;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameEndOffsetAndLineNumber(int n, int n2) {
        this.nameEndOffset = n;
    }

    public void setNameStartOffset(int n) {
        this.nameStartOffset = n;
    }

    public List getPointerOperators() {
        return Collections.unmodifiableList(this.ptrOps);
    }

    public void addPointerOperator(ASTPointerOperator aSTPointerOperator) {
        this.ptrOps.add(aSTPointerOperator);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(DeclarationWrapper declarationWrapper) {
        this.parameters.add(declarationWrapper);
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public void setInitializerClause(IASTInitializerClause iASTInitializerClause) {
        this.initializerClause = iASTInitializerClause;
    }

    public Declarator getOwnedDeclarator() {
        return this.ownedDeclarator;
    }

    public void setOwnedDeclarator(Declarator declarator) {
        this.ownedDeclarator = declarator;
    }

    public void setName(ITokenDuple iTokenDuple) {
        this.setName(iTokenDuple.toString());
        this.setNameStartOffset(iTokenDuple.getFirstToken().getOffset());
        this.setNameEndOffsetAndLineNumber(iTokenDuple.getLastToken().getEndOffset(), iTokenDuple.getLastToken().getLineNumber());
        this.namedDuple = iTokenDuple;
    }

    public IASTExceptionSpecification getExceptionSpecification() {
        return this.exceptionSpecification;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setExceptionSpecification(IASTExceptionSpecification iASTExceptionSpecification) {
        this.exceptionSpecification = iASTExceptionSpecification;
    }

    public void setConst(boolean bl) {
        this.isConst = bl;
    }

    public void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public boolean isKandR() {
        return this.isKandR;
    }

    public void setKandR(boolean bl) {
        this.isKandR = bl;
    }

    public void setPureVirtual(boolean bl) {
        this.pureVirtual = bl;
    }

    public boolean isPureVirtual() {
        return this.pureVirtual;
    }

    public void addArrayModifier(IASTArrayModifier iASTArrayModifier) {
        this.arrayModifiers.add(iASTArrayModifier);
    }

    public List getArrayModifiers() {
        return this.arrayModifiers;
    }

    public IASTExpression getBitFieldExpression() {
        return this.bitFieldExpression;
    }

    public void setBitFieldExpression(IASTExpression iASTExpression) {
        this.bitFieldExpression = iASTExpression;
    }

    public void setConstructorExpression(IASTExpression iASTExpression) {
        this.constructorExpression = iASTExpression;
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public void addConstructorMemberInitializer(IASTConstructorMemberInitializer iASTConstructorMemberInitializer) {
        this.constructorMemberInitializers.add(iASTConstructorMemberInitializer);
    }

    public List getConstructorMemberInitializers() {
        return this.constructorMemberInitializers;
    }

    public void hasFunctionBody(boolean bl) {
        this.hasFunctionBody = bl;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public void setIsFunction(boolean bl) {
        this.isFunction = bl;
    }

    public Iterator getDeclarators() {
        ArrayList<Declarator> arrayList = new ArrayList<Declarator>();
        if (this.ownedDeclarator != null) {
            arrayList.add(this.ownedDeclarator);
        }
        return arrayList.iterator();
    }

    public DeclarationWrapper getDeclarationWrapper() {
        Declarator declarator = this;
        while (declarator.getOwner() instanceof IDeclarator) {
            declarator = (Declarator)declarator.getOwner();
        }
        return (DeclarationWrapper)declarator.getOwner();
    }

    public ITokenDuple getNameDuple() {
        return this.namedDuple;
    }

    public void setPointerOperatorName(ITokenDuple iTokenDuple) {
        this.pointerOperatorNameDuple = iTokenDuple;
    }

    public ITokenDuple getPointerOperatorNameDuple() {
        return this.pointerOperatorNameDuple;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public void setHasFunctionBody(boolean bl) {
        this.hasFunctionBody = bl;
    }

    public void setFunctionTryBlock(boolean bl) {
        this.hasFunctionTryBlock = true;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public void setHasFunctionTryBlock(boolean bl) {
        this.hasFunctionTryBlock = bl;
    }

    public void setIsVarArgs(boolean bl) {
        this.varArgs = bl;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public IASTScope getScope() {
        return this.getDeclarationWrapper().getScope();
    }
}

