/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.wizards;

import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.SWTUtil;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddDirectorySourceLocationBlock {
    private Composite fControl = null;
    private Text fLocationText = null;
    private Text fAssociationText = null;
    private Button fAssocitedCheckButton = null;
    private Button fSearchSubfoldersButton = null;
    private Shell fShell = null;
    private IPath fInitialAssosciationPath = null;

    public AddDirectorySourceLocationBlock(IPath iPath) {
        this.fInitialAssosciationPath = iPath;
    }

    public void createControl(Composite composite) {
        this.fShell = composite.getShell();
        this.fControl = new Composite(composite, 0);
        this.fControl.setLayout((Layout)new GridLayout());
        this.fControl.setLayoutData((Object)new GridData(768));
        this.fControl.setFont(JFaceResources.getDialogFont());
        this.createLocationControls(this.fControl);
        this.createAssociationControls(this.fControl);
        this.createSearchSubfoldersButton(this.fControl);
        this.setInitialAssociationPath();
    }

    private void setInitialAssociationPath() {
        this.fAssociationText.setEnabled(this.fInitialAssosciationPath != null);
        this.fAssocitedCheckButton.setSelection(this.fInitialAssosciationPath != null);
        if (this.fInitialAssosciationPath != null) {
            this.fAssociationText.setText(this.fInitialAssosciationPath.toOSString());
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void createLocationControls(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(CDebugUIPlugin.getResourceString("AddDirectorySourceLocationBlock.Select_location_directory"));
        label.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
        composite2.setLayoutData((Object)gridData);
        this.fLocationText = new Text(composite2, 2052);
        this.fLocationText.setLayoutData((Object)new GridData(768));
        Button button = this.createButton(composite2, CDebugUIPlugin.getResourceString("AddDirectorySourceLocationBlock.Browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddDirectorySourceLocationBlock.this.selectLocation();
            }
        });
    }

    protected void selectLocation() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fShell);
        directoryDialog.setMessage(CDebugUIPlugin.getResourceString("AddDirectorySourceLocationBlock.Select_Location_Directory"));
        String string = directoryDialog.open();
        if (string != null) {
            this.fLocationText.setText(string);
        }
    }

    protected void createAssociationControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.fAssocitedCheckButton = new Button(composite2, 32);
        this.fAssocitedCheckButton.setText(CDebugUIPlugin.getResourceString("AddDirectorySourceLocationBlock.Associate_with"));
        this.fAssociationText = new Text(composite2, 2052);
        this.fAssociationText.setLayoutData((Object)new GridData(768));
        this.fAssocitedCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddDirectorySourceLocationBlock.this.associationSelectionChanged();
            }
        });
    }

    protected void associationSelectionChanged() {
        boolean bl = this.fAssocitedCheckButton.getSelection();
        this.fAssociationText.setEnabled(bl);
        if (!bl) {
            this.fAssociationText.setText("");
        }
    }

    protected void createSearchSubfoldersButton(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.fSearchSubfoldersButton = new Button(composite2, 32);
        this.fSearchSubfoldersButton.setText(CDebugUIPlugin.getResourceString("AddDirectorySourceLocationBlock.Search_subfolders"));
    }

    protected Button createButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData(3);
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint(button);
        button.setFont(composite.getFont());
        return button;
    }

    public String getLocationPath() {
        return this.fLocationText.getText().trim();
    }

    public String getAssociationPath() {
        if (this.fAssocitedCheckButton.getSelection()) {
            return this.fAssociationText.getText().trim();
        }
        return "";
    }

    public boolean searchSubfolders() {
        return this.fSearchSubfoldersButton != null ? this.fSearchSubfoldersButton.getSelection() : false;
    }

    public IDirectorySourceLocation getSourceLocation() {
        if (this.isLocationPathValid()) {
            Path path = this.isAssociationPathValid() ? new Path(this.getAssociationPath()) : null;
            return SourceLookupFactory.createDirectorySourceLocation((IPath)new Path(this.getLocationPath()), (IPath)path, (boolean)this.searchSubfolders());
        }
        return null;
    }

    public void addDirectoryModifyListener(ModifyListener modifyListener) {
        if (this.fLocationText != null) {
            this.fLocationText.addModifyListener(modifyListener);
        }
    }

    public void addAssociationModifyListener(ModifyListener modifyListener) {
        if (this.fAssociationText != null) {
            this.fAssociationText.addModifyListener(modifyListener);
        }
    }

    public void removeDirectoryModifyListener(ModifyListener modifyListener) {
        if (this.fLocationText != null) {
            this.fLocationText.removeModifyListener(modifyListener);
        }
    }

    public void removeAssociationModifyListener(ModifyListener modifyListener) {
        if (this.fAssociationText != null) {
            this.fAssociationText.removeModifyListener(modifyListener);
        }
    }

    private boolean isLocationPathValid() {
        if (this.fLocationText != null && Path.EMPTY.isValidPath(this.fLocationText.getText().trim())) {
            Path path = new Path(this.fLocationText.getText().trim());
            return path.toFile().exists() && path.toFile().isAbsolute();
        }
        return false;
    }

    public boolean isAssociationPathValid() {
        String string = this.getAssociationPath();
        if (string.length() > 0) {
            return Path.EMPTY.isValidPath(string);
        }
        return true;
    }
}

