/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.editors.NoSymbolOrSourceElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    public static final String ID_OLD_DEFAULT_SOURCE_LOCATOR = "org.eclipse.cdt.launch.DefaultSourceLocator";
    private static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    private ICSourceLocator fSourceLocator;
    private HashMap fFramesToSource = null;
    private HashMap fNamesToSource = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public String getMemento() throws CoreException {
        if (this.getCSourceLocator() != null) {
            DocumentImpl documentImpl = new DocumentImpl();
            Element element = documentImpl.createElement(ELEMENT_NAME);
            documentImpl.appendChild(element);
            element.setAttribute(ATTR_PROJECT, this.getCSourceLocator().getProject().getName());
            IPersistableSourceLocator iPersistableSourceLocator = this.getPersistableSourceLocator();
            if (iPersistableSourceLocator != null) {
                element.setAttribute(ATTR_MEMENTO, iPersistableSourceLocator.getMemento());
            }
            try {
                return CDebugUtils.serializeDocument((Document)documentImpl, (String)" ");
            }
            catch (IOException iOException) {
                this.abort(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Unable_to_create_memento_for_src_location"), iOException);
            }
        }
        return null;
    }

    public void initializeFromMemento(String string) throws CoreException {
        Exception exception = null;
        try {
            IPersistableSourceLocator iPersistableSourceLocator;
            Element element = null;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            element = documentBuilder.parse(inputSource).getDocumentElement();
            if (!element.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Unable_to_restore_prompting_src_locator"), null);
            }
            String string2 = element.getAttribute(ATTR_PROJECT);
            String string3 = element.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(string2)) {
                this.abort(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Unable_to_restore_prompting_src_locator"), null);
            }
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
            if (this.getCSourceLocator() == null) {
                this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)iProject));
            }
            if (this.getCSourceLocator().getProject() != null && !this.getCSourceLocator().getProject().equals((Object)iProject)) {
                return;
            }
            if (iProject == null || !iProject.exists() || !iProject.isOpen()) {
                this.abort(MessageFormat.format(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Unable_to_restore_prompting_src_locator_project_not_found"), string2), null);
            }
            if ((iPersistableSourceLocator = this.getPersistableSourceLocator()) != null) {
                iPersistableSourceLocator.initializeFromMemento(string3);
            } else {
                this.abort(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Unable_to_restore_prompting_src_locator_project_not_found"), null);
            }
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        this.abort(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Exception_initializing_src_locator"), exception);
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)this.getProject(iLaunchConfiguration)));
        String string = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(string)) {
            this.initializeFromMemento(string);
        }
    }

    public Object getAdapter(Class clazz) {
        if (this.getCSourceLocator() instanceof IAdaptable) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(clazz);
            }
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz3)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(clazz);
            }
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz4)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(clazz);
            }
        }
        return null;
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        Object object;
        Object object2 = this.cacheLookup(iStackFrame);
        if (object2 == null && (object2 = this.getCSourceLocator().getSourceElement(iStackFrame)) instanceof List) {
            object = (List)object2;
            if (object.size() != 0) {
                SourceSelectionDialog sourceSelectionDialog = this.createSourceSelectionDialog((List)object);
                sourceSelectionDialog.open();
                Object[] objectArray = sourceSelectionDialog.getResult();
                Object object3 = object2 = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
                if (object2 != null) {
                    this.cacheSourceElement(iStackFrame, object2, sourceSelectionDialog.alwaysMapToSelection());
                }
            } else {
                object2 = null;
            }
        }
        if (object2 == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object2 = (object = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null && object.getFile() != null && object.getFile().length() > 0 ? new FileNotFoundElement(iStackFrame) : new NoSymbolOrSourceElement(iStackFrame);
        }
        return object2;
    }

    protected void saveChanges(ILaunchConfiguration iLaunchConfiguration, IPersistableSourceLocator iPersistableSourceLocator) {
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(iLaunchConfiguration.getName());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, iPersistableSourceLocator.getMemento());
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(coreException.getMessage(), null);
        }
    }

    private SourceSelectionDialog createSourceSelectionDialog(List list) {
        SourceSelectionDialog sourceSelectionDialog = new SourceSelectionDialog(CDebugUIPlugin.getActiveWorkbenchShell());
        sourceSelectionDialog.setInput(list.toArray());
        sourceSelectionDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        sourceSelectionDialog.setLabelProvider((ILabelProvider)new SourceElementLabelProvider());
        sourceSelectionDialog.setTitle(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Selection_needed"));
        sourceSelectionDialog.setMessage(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Select_file_associated_with_stack_frame"));
        sourceSelectionDialog.setInitialSelections(new Object[]{list.get(0)});
        return sourceSelectionDialog;
    }

    private void cacheSourceElement(IStackFrame iStackFrame, Object object, boolean bl) {
        if (bl) {
            String string = this.getFileName(iStackFrame);
            if (string != null) {
                if (this.fNamesToSource == null) {
                    this.fNamesToSource = new HashMap();
                }
                this.fNamesToSource.put(string, object);
            }
        } else {
            if (this.fFramesToSource == null) {
                this.fFramesToSource = new HashMap();
            }
            this.fFramesToSource.put(iStackFrame, object);
        }
    }

    private Object cacheLookup(IStackFrame iStackFrame) {
        Object v;
        String string = this.getFileName(iStackFrame);
        if (string != null && this.fNamesToSource != null && (v = this.fNamesToSource.get(string)) != null) {
            return v;
        }
        return this.fFramesToSource != null ? this.fFramesToSource.get(iStackFrame) : null;
    }

    private String getFileName(IStackFrame iStackFrame) {
        String string;
        IStackFrameInfo iStackFrameInfo;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iStackFrameInfo = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null && (string = iStackFrameInfo.getFile()) != null && string.trim().length() > 0) {
            return string.trim();
        }
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        return this.fSourceLocator;
    }

    private void setCSourceLocator(ICSourceLocator iCSourceLocator) {
        this.fSourceLocator = iCSourceLocator;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator iCSourceLocator = this.getCSourceLocator();
        return iCSourceLocator instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)iCSourceLocator : null;
    }

    private void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private IProject getProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IProject iProject;
        String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(string) && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)).exists()) {
            return iProject;
        }
        this.abort(MessageFormat.format(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Project_does_not_exist"), string), null);
        return null;
    }

    public class SourceSelectionDialog
    extends ListDialog {
        private SelectionButtonDialogField fAlwaysUseThisFileButton = new SelectionButtonDialogField(32);

        public SourceSelectionDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)1);
            super.createDialogArea(composite2);
            Composite composite3 = ControlFactory.createComposite((Composite)composite2, (int)1);
            this.fAlwaysUseThisFileButton.setLabelText(CDebugUIPlugin.getResourceString("ui.sourcelookup.DefaultSourceLocator.Always_map_to_selection"));
            this.fAlwaysUseThisFileButton.doFillIntoGrid(composite3, 1);
            return composite2;
        }

        public boolean alwaysMapToSelection() {
            return this.fAlwaysUseThisFileButton.isSelected();
        }
    }

    public class SourceElementLabelProvider
    extends LabelProvider {
        protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();

        public String getText(Object object) {
            if (object instanceof IFile) {
                return ((IFile)object).getFullPath().toString();
            }
            if (object instanceof FileStorage) {
                return ((FileStorage)object).getFullPath().toOSString();
            }
            return super.getText(object);
        }

        public Image getImage(Object object) {
            if (object instanceof IFile) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_WORKSPACE_SOURCE_FILE);
            }
            if (object instanceof FileStorage) {
                return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_EXTERNAL_SOURCE_FILE);
            }
            return super.getImage(object);
        }
    }
}

