/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.cdt.debug.internal.core.model.CCoreFileDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CFormattedMemoryBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IProcess iProcess2, final IFile iFile, final boolean bl, final boolean bl2, boolean bl3) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CDebugTarget(iLaunch, 1, iCDITarget, string, iProcess, iProcess2, iFile, bl, bl2);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ICDIConfiguration iCDIConfiguration = iCDITarget.getSession().getConfiguration();
        if (iCDIConfiguration.supportsBreakpoints() && bl3) {
            CDebugModel.stopInMain((CDebugTarget)iDebugTargetArray[0]);
        }
        if (iCDIConfiguration.supportsResume()) {
            iDebugTargetArray[0].resume();
        }
        return iDebugTargetArray[0];
    }

    public static IDebugTarget newAttachDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IFile iFile) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CDebugTarget(iLaunch, 2, iCDITarget, string, null, iProcess, iFile, false, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ((CDebugTarget)iDebugTargetArray[0]).handleDebugEvent(new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return iCDITarget;
            }
        });
        return iDebugTargetArray[0];
    }

    public static IDebugTarget newCoreFileDebugTarget(final ILaunch iLaunch, final ICDITarget iCDITarget, final String string, final IProcess iProcess, final IFile iFile) throws DebugException {
        final IDebugTarget[] iDebugTargetArray = new IDebugTarget[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) {
                iDebugTargetArray[0] = new CCoreFileDebugTarget(iLaunch, iCDITarget, string, iProcess, iFile);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            CDebugCorePlugin.log(coreException);
            throw new DebugException(coreException.getStatus());
        }
        ((CDebugTarget)iDebugTargetArray[0]).handleDebugEvent(new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return iCDITarget;
            }
        });
        return iDebugTargetArray[0];
    }

    public static ICLineBreakpoint lineBreakpointExists(String string, int n) throws CoreException {
        String string2 = CDebugModel.getPluginIdentifier();
        String string3 = CLineBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            ICLineBreakpoint iCLineBreakpoint;
            if (iBreakpointArray[n2] instanceof ICLineBreakpoint && (iCLineBreakpoint = (ICLineBreakpoint)iBreakpointArray[n2]).getMarker().getType().equals(string3) && iCLineBreakpoint.getMarker().getResource().getLocation().toOSString().equals(string) && iCLineBreakpoint.getLineNumber() == n) {
                return iCLineBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    public static ICLineBreakpoint createLineBreakpoint(IResource iResource, int n, boolean bl, int n2, String string, boolean bl2) throws DebugException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        hashMap.put("lineNumber", new Integer(n));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n2));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string);
        return new CLineBreakpoint(iResource, hashMap, bl2);
    }

    public static ICAddressBreakpoint addressBreakpointExists(IResource iResource, long l) throws CoreException {
        String string = CDebugModel.getPluginIdentifier();
        String string2 = CAddressBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICAddressBreakpoint iCAddressBreakpoint;
            if (iBreakpointArray[n] instanceof ICAddressBreakpoint && (iCAddressBreakpoint = (ICAddressBreakpoint)iBreakpointArray[n]).getMarker().getType().equals(string2) && iCAddressBreakpoint.getMarker().getResource().getLocation().toOSString().equals(iResource.getLocation().toOSString())) {
                try {
                    if (Long.parseLong(iCAddressBreakpoint.getAddress()) == l) {
                        return iCAddressBreakpoint;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n;
        }
        return null;
    }

    public static ICAddressBreakpoint createAddressBreakpoint(IResource iResource, long l, boolean bl, int n, String string, boolean bl2) throws DebugException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        hashMap.put("charStart", new Integer(0));
        hashMap.put("charEnd", new Integer(0));
        hashMap.put("lineNumber", new Integer(-1));
        hashMap.put("lineNumber", new Integer(-1));
        hashMap.put("org.eclipse.cdt.debug.core.address", Long.toString(l));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string);
        return new CAddressBreakpoint(iResource, hashMap, bl2);
    }

    public static ICFunctionBreakpoint functionBreakpointExists(IFunction iFunction) throws CoreException {
        String string = CDebugModel.getPluginIdentifier();
        String string2 = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICFunctionBreakpoint iCFunctionBreakpoint;
            if (iBreakpointArray[n] instanceof ICFunctionBreakpoint && (iCFunctionBreakpoint = (ICFunctionBreakpoint)iBreakpointArray[n]).getMarker().getType().equals(string2) && iCFunctionBreakpoint.getMarker().getResource().equals((Object)CDebugUtils.getFunctionResource(iFunction)) && iCFunctionBreakpoint.getFunction() != null && iCFunctionBreakpoint.getFunction().equals(CDebugUtils.getFunctionName(iFunction))) {
                return iCFunctionBreakpoint;
            }
            ++n;
        }
        return null;
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(IFunction iFunction, boolean bl, int n, String string, boolean bl2) throws DebugException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            ISourceRange iSourceRange = iFunction.getSourceRange();
            if (iSourceRange != null && (n4 = (n3 = iSourceRange.getStartPos()) + iSourceRange.getLength()) == 0) {
                n2 = iSourceRange.getStartLine();
            }
        }
        catch (CModelException cModelException) {
            CDebugCorePlugin.log(cModelException.getStatus());
        }
        hashMap.put("charStart", new Integer(n3));
        hashMap.put("charEnd", new Integer(n4));
        hashMap.put("lineNumber", new Integer(n2));
        hashMap.put("org.eclipse.cdt.debug.core.function", CDebugUtils.getFunctionName(iFunction));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string);
        return new CFunctionBreakpoint(CDebugUtils.getFunctionResource(iFunction), hashMap, bl2);
    }

    public static ICFunctionBreakpoint methodBreakpointExists(IMethod iMethod) throws CoreException {
        String string = CDebugModel.getPluginIdentifier();
        String string2 = CFunctionBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICFunctionBreakpoint iCFunctionBreakpoint;
            if (iBreakpointArray[n] instanceof ICFunctionBreakpoint && (iCFunctionBreakpoint = (ICFunctionBreakpoint)iBreakpointArray[n]).getMarker().getType().equals(string2) && iCFunctionBreakpoint.getMarker().getResource().equals((Object)CDebugUtils.getMethodResource(iMethod)) && iCFunctionBreakpoint.getFunction() != null && iCFunctionBreakpoint.getFunction().equals(CDebugUtils.getMethodQualifiedName(iMethod))) {
                return iCFunctionBreakpoint;
            }
            ++n;
        }
        return null;
    }

    public static ICFunctionBreakpoint createMethodBreakpoint(IMethod iMethod, boolean bl, int n, String string, boolean bl2) throws DebugException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            ISourceRange iSourceRange = iMethod.getSourceRange();
            if (iSourceRange != null && (n4 = (n3 = iSourceRange.getStartPos()) + iSourceRange.getLength()) == 0) {
                n2 = iSourceRange.getStartLine();
            }
        }
        catch (CModelException cModelException) {
            CDebugCorePlugin.log(cModelException.getStatus());
        }
        hashMap.put("charStart", new Integer(n3));
        hashMap.put("charEnd", new Integer(n4));
        hashMap.put("lineNumber", new Integer(n2));
        hashMap.put("org.eclipse.cdt.debug.core.function", CDebugUtils.getMethodQualifiedName(iMethod));
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string);
        return new CFunctionBreakpoint(CDebugUtils.getMethodResource(iMethod), hashMap, bl2);
    }

    public static ICWatchpoint watchpointExists(IResource iResource, boolean bl, boolean bl2, String string) throws CoreException {
        String string2 = CDebugModel.getPluginIdentifier();
        String string3 = CWatchpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n = 0;
        while (n < iBreakpointArray.length) {
            ICWatchpoint iCWatchpoint;
            if (iBreakpointArray[n] instanceof ICWatchpoint && (iCWatchpoint = (ICWatchpoint)iBreakpointArray[n]).getMarker().getType().equals(string3) && iCWatchpoint.getMarker().getResource().equals((Object)iResource) && iCWatchpoint.isWriteType() == bl && iCWatchpoint.isReadType() == bl2 && iCWatchpoint.getExpression().equals(string)) {
                return iCWatchpoint;
            }
            ++n;
        }
        return null;
    }

    public static ICWatchpoint createWatchpoint(IResource iResource, boolean bl, boolean bl2, String string, boolean bl3, int n, String string2, boolean bl4) throws DebugException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        hashMap.put("org.eclipse.debug.core.id", CDebugModel.getPluginIdentifier());
        hashMap.put("org.eclipse.debug.core.enabled", new Boolean(bl3));
        hashMap.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(n));
        hashMap.put("org.eclipse.cdt.debug.core.condition", string2);
        hashMap.put("org.eclipse.cdt.debug.core.expression", string);
        hashMap.put("org.eclipse.cdt.debug.core.read", new Boolean(bl2));
        hashMap.put("org.eclipse.cdt.debug.core.write", new Boolean(bl));
        return new CWatchpoint(iResource, hashMap, bl4);
    }

    public static IExpression createExpression(IDebugTarget iDebugTarget, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                return new CExpression((CDebugTarget)iDebugTarget, iCDIExpression);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static IExpression createExpressionForGlobalVariable(IDebugTarget iDebugTarget, IPath iPath, String string) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIVariableObject iCDIVariableObject = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().getGlobalVariableObject(iPath.lastSegment(), null, string);
                ICDIVariable iCDIVariable = ((CDebugTarget)iDebugTarget).getCDISession().getVariableManager().createVariable(iCDIVariableObject);
                return new CExpression((CDebugTarget)iDebugTarget, (ICDIVariableObject)iCDIVariable);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget iDebugTarget, String string, int n, int n2, int n3, int n4, char c) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                ICDIMemoryBlock iCDIMemoryBlock = ((CDebugTarget)iDebugTarget).getCDISession().getMemoryManager().createMemoryBlock(iCDIExpression.getName(), n2 * n3 * n4);
                return new CFormattedMemoryBlock((CDebugTarget)iDebugTarget, iCDIMemoryBlock, iCDIExpression, n, n2, n3, n4, c);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getDetailMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget iDebugTarget, String string, int n, int n2, int n3, int n4) throws DebugException {
        if (iDebugTarget != null && iDebugTarget instanceof CDebugTarget) {
            try {
                ICDIExpression iCDIExpression = ((CDebugTarget)iDebugTarget).getCDISession().getExpressionManager().createExpression(string);
                ICDIMemoryBlock iCDIMemoryBlock = ((CDebugTarget)iDebugTarget).getCDISession().getMemoryManager().createMemoryBlock(iCDIExpression.getName(), n2 * n3 * n4);
                return new CFormattedMemoryBlock((CDebugTarget)iDebugTarget, iCDIMemoryBlock, iCDIExpression, n, n2, n3, n4);
            }
            catch (CDIException cDIException) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, cDIException.getDetailMessage(), null));
            }
        }
        return null;
    }

    private static void stopInMain(CDebugTarget cDebugTarget) throws DebugException {
        block2: {
            ICDILocation iCDILocation = cDebugTarget.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            try {
                cDebugTarget.setInternalTemporaryBreakpoint(iCDILocation);
            }
            catch (DebugException debugException) {
                String string = MessageFormat.format("Unable to set temporary breakpoint in main.\nReason: {0}\nContinue?", debugException.getStatus().getMessage());
                Status status = new Status(2, debugException.getStatus().getPlugin(), 10000, string, null);
                if (CDebugUtils.question((IStatus)status, cDebugTarget)) break block2;
                cDebugTarget.terminate();
                throw new DebugException((IStatus)new Status(0, debugException.getStatus().getPlugin(), debugException.getStatus().getCode(), debugException.getStatus().getMessage(), null));
            }
        }
    }
}

