/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CWatchpoint
extends CBreakpoint
implements ICWatchpoint {
    private static final String C_WATCHPOINT = "org.eclipse.cdt.debug.core.cWatchpointMarker";

    public CWatchpoint() {
    }

    public CWatchpoint(IResource iResource, Map map, boolean bl) throws DebugException {
        super(iResource, CWatchpoint.getMarkerType(), map, bl);
    }

    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.write", true);
    }

    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.read", false);
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.expression", "");
    }

    public static String getMarkerType() {
        return C_WATCHPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isWriteType() && !this.isReadType()) {
            stringBuffer.append("Write ");
        } else if (!this.isWriteType() && this.isReadType()) {
            stringBuffer.append("Read ");
        } else if (this.isWriteType() && this.isReadType()) {
            stringBuffer.append("Access ");
        }
        stringBuffer.append("watchpoint: ");
        String string2 = this.ensureMarker().getResource().getName();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if ((string = this.getExpression()) != null && string.length() > 0) {
            stringBuffer.append(" at '");
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

