/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferFactory;
import org.eclipse.cdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;

public class TextBuffer {
    private IDocument fDocument;
    private static final TextBufferFactory fgFactory = new TextBufferFactory();

    public IDocument getDocument() {
        return this.fDocument;
    }

    TextBuffer(IDocument iDocument) {
        this.fDocument = iDocument;
        Assert.isNotNull((Object)this.fDocument);
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public int getNumberOfLines() {
        return this.fDocument.getNumberOfLines();
    }

    public char getChar(int n) {
        try {
            return this.fDocument.getChar(n);
        }
        catch (BadLocationException badLocationException) {
            throw new ArrayIndexOutOfBoundsException(badLocationException.getMessage());
        }
    }

    public String getContent() {
        return this.fDocument.get();
    }

    public String getContent(int n, int n2) {
        try {
            return this.fDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getLineDelimiter() {
        String string = this.getLineDelimiter(0);
        if (string == null) {
            string = System.getProperty("line.separator", "\n");
        }
        return string;
    }

    public String getLineDelimiter(int n) {
        try {
            return this.fDocument.getLineDelimiter(n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getLineContent(int n) {
        try {
            IRegion iRegion = this.fDocument.getLineInformation(n);
            return this.fDocument.get(iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getLineIndent(int n, int n2) {
        return TextBuffer.getIndent(this.getLineContent(n), n2);
    }

    public TextRegion getLineInformation(int n) {
        try {
            return new DocumentRegion(this.fDocument.getLineInformation(n));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public TextRegion getLineInformationOfOffset(int n) {
        try {
            return new DocumentRegion(this.fDocument.getLineInformationOfOffset(n));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getLineOfOffset(int n) {
        try {
            return this.fDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public String getLineContentOfOffset(int n) {
        try {
            IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
            return this.fDocument.get(iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String[] convertIntoLines(int n, int n2) {
        try {
            String string = this.fDocument.get(n, n2);
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n3 = defaultLineTracker.getNumberOfLines();
            String[] stringArray = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n4);
                stringArray[n4] = this.getContent(n + iRegion.getOffset(), iRegion.getLength());
                ++n4;
            }
            return stringArray;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void replace(int n, int n2, String string) throws CoreException {
        try {
            this.fDocument.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {
            Status status = new Status(4, "org.eclipse.cdt.ui", 1, TextManipulationMessages.getFormattedString("TextBuffer.wrongRange", new Object[]{new Integer(n), new Integer(n2)}), (Throwable)badLocationException);
            throw new CoreException((IStatus)status);
        }
    }

    public void replace(TextRange textRange, String string) throws CoreException {
        this.replace(textRange.fOffset, textRange.fLength, string);
    }

    void release() {
    }

    void registerUpdater(IDocumentListener iDocumentListener) {
        this.fDocument.addDocumentListener(iDocumentListener);
    }

    void unregisterUpdater(IDocumentListener iDocumentListener) {
        this.fDocument.removeDocumentListener(iDocumentListener);
    }

    public static int getIndent(String string, int n) {
        if (string == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        block4: while (n5 < n4) {
            switch (string.charAt(n5)) {
                case '\t': {
                    ++n2;
                    n3 = 0;
                    break;
                }
                case ' ': {
                    if (++n3 != n) break;
                    ++n2;
                    n3 = 0;
                    break;
                }
                default: {
                    break block4;
                }
            }
            ++n5;
        }
        return n2;
    }

    public static String removeIndent(String string, int n, int n2) {
        if (string != null) {
            int n3 = 0;
            int n4 = 0;
            int n5 = string.length();
            int n6 = 0;
            while (n6 < n5) {
                if (n3 >= n) {
                    string = string.substring(n6);
                    break;
                }
                switch (string.charAt(n6)) {
                    case '\t': {
                        ++n3;
                        n4 = 0;
                        break;
                    }
                    case ' ': {
                        if (++n4 != n2) break;
                        ++n3;
                        n4 = 0;
                    }
                }
                ++n6;
            }
        }
        return string;
    }

    public static TextBuffer acquire(IFile iFile) throws CoreException {
        return fgFactory.acquire(iFile);
    }

    public static void release(TextBuffer textBuffer) {
        fgFactory.release(textBuffer);
    }

    public static void commitChanges(TextBuffer textBuffer, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        fgFactory.commitChanges(textBuffer, bl, iProgressMonitor);
    }

    public static TextBuffer create(IFile iFile) throws CoreException {
        return fgFactory.create(iFile);
    }

    public static TextBuffer create(String string) throws CoreException {
        return fgFactory.create(string);
    }

    public static void save(TextBuffer textBuffer, IProgressMonitor iProgressMonitor) throws CoreException {
        fgFactory.save(textBuffer, iProgressMonitor);
    }

    public static void aboutToChange(TextBuffer textBuffer) throws CoreException {
        fgFactory.aboutToChange(textBuffer);
    }

    public static void changed(TextBuffer textBuffer) throws CoreException {
        fgFactory.changed(textBuffer);
    }

    private static class DocumentRegion
    extends TextRegion {
        IRegion fRegion;

        public DocumentRegion(IRegion iRegion) {
            this.fRegion = iRegion;
        }

        public int getOffset() {
            return this.fRegion.getOffset();
        }

        public int getLength() {
            return this.fRegion.getLength();
        }
    }
}

