/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CMarkerAnnotation
extends MarkerAnnotation
implements IProblemAnnotation {
    private boolean fIsProblemMarker;
    private IDocument fDocument;
    private int error_start = -1;
    private int error_length = 0;
    private IDebugModelPresentation fPresentation;

    public CMarkerAnnotation(IMarker iMarker, IDocument iDocument) {
        super(iMarker);
        this.fDocument = iDocument;
        if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
            this.fIsProblemMarker = true;
            try {
                int n;
                String string = (String)this.getMarker().getAttribute("problem.variable");
                if (string != null && this.fDocument != null && (n = this.getMarker().getAttribute("location", -1) - 1) >= 0) {
                    int n2 = this.fDocument.getLineOffset(n);
                    String string2 = this.fDocument.get(n2, this.fDocument.getLineLength(n));
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 != -1) {
                        n3 = this.getStart(string2, string, n4);
                        if (n3 >= 0 && !Character.isJavaIdentifierStart(string2.charAt(n3 + string.length()))) break;
                        n4 += string.length();
                    }
                    if (n3 >= 0) {
                        int n5 = n3 + string.length();
                        Map map = iMarker.getAttributes();
                        MarkerUtilities.setCharStart((Map)map, (int)(n2 + n3));
                        MarkerUtilities.setCharEnd((Map)map, (int)(n2 + n5));
                        this.error_start = n2 + n3;
                        this.error_length = n5 - n3;
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private int getStart(String string, String string2, int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 != -1) {
            if ((n3 = string.indexOf(string2, n3)) == -1) continue;
            ++n2;
            n3 += string2.length();
        }
        if (n2 == 1) {
            return string.indexOf(string2, n);
        }
        int n4 = n;
        n4 = string.indexOf("\"", n4);
        int n5 = -1;
        n3 = n;
        if (n4 == -1) {
            n5 = string.indexOf(string2, n3);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n3), "\"", true);
            String string3 = null;
            int n6 = 0;
            int n7 = -1;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string3 = stringTokenizer.nextToken();
                if ("\"".equals(string3)) {
                    ++n6;
                } else if (n6 % 2 == 0 && (n7 = string3.indexOf(string2, 0)) != -1) {
                    bl = true;
                    n5 = n3 += n7;
                    break;
                }
                n3 += string3.length();
            }
        }
        return n5;
    }

    protected void initialize() {
        try {
            IMarker iMarker = this.getMarker();
            if (MarkerUtilities.isMarkerType((IMarker)iMarker, (String)"org.eclipse.search.searchmarker")) {
                this.setLayer(2);
                this.setImage(SearchUI.getSearchMarkerImage());
                this.fIsProblemMarker = false;
                return;
            }
            if (MarkerUtilities.isMarkerType((IMarker)iMarker, (String)IBreakpoint.LINE_BREAKPOINT_MARKER)) {
                if (this.fPresentation == null) {
                    this.fPresentation = DebugUITools.newDebugModelPresentation();
                }
                this.setLayer(4);
                this.setImage(this.fPresentation.getImage((Object)iMarker));
                this.fIsProblemMarker = false;
                return;
            }
            if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
                int n;
                this.fIsProblemMarker = true;
                String string = (String)iMarker.getAttribute("problem.variable");
                if (string != null && this.fDocument != null && (n = iMarker.getAttribute("location", -1)) >= 0 && n == -1) {
                    try {
                        int n2 = this.fDocument.getLineOffset(n);
                        System.out.println("offset " + n2);
                        String string2 = this.fDocument.get(n2, this.fDocument.getLineLength(n));
                        System.out.println("text:" + string2);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else {
                this.fIsProblemMarker = iMarker.isSubtypeOf("org.eclipse.cdt.core.problem") ? true : !iMarker.isSubtypeOf("org.eclipse.core.resources.taskmarker") && !iMarker.isSubtypeOf("org.eclipse.cdt.core.task");
            }
        }
        catch (CoreException coreException) {}
        super.initialize();
    }

    public String getMessage() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("message", "");
        }
        return "";
    }

    public boolean isError() {
        if (this.fIsProblemMarker) {
            int n = this.getMarker().getAttribute("severity", -1);
            return n == 2;
        }
        return false;
    }

    public boolean isWarning() {
        if (this.fIsProblemMarker) {
            int n = this.getMarker().getAttribute("severity", -1);
            return n == 1;
        }
        return false;
    }

    public boolean isTemporaryProblem() {
        return false;
    }

    public String[] getArguments() {
        String[] stringArray = new String[]{"problem", "here"};
        return stringArray;
    }

    public int getId() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("org.eclipse.cdt.core.problem", -1);
        }
        return 0;
    }

    public boolean isProblem() {
        return this.fIsProblemMarker;
    }

    public int getErrorStart() {
        return this.error_start;
    }

    public int getErrorLength() {
        return this.error_length;
    }
}

