/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskInputDialog;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TodoTaskConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    private static final String PREF_TRANSLATION_TASK_PRIORITIES = "org.eclipse.cdt.core.translation.taskPriorities";
    private static final String PRIORITY_HIGH = "HIGH";
    private static final String PRIORITY_NORMAL = "NORMAL";
    private static final String PRIORITY_LOW = "LOW";
    private PixelConverter fPixelConverter;
    private IStatus fTaskTagsStatus;
    private ListDialogField fTodoTasksList;

    public TodoTaskConfigurationBlock(IStatusChangeListener iStatusChangeListener, ICProject iCProject) {
        super(iStatusChangeListener, iCProject);
        TaskTagAdapter taskTagAdapter = new TaskTagAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.add.button");
        stringArray[1] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.remove.button");
        stringArray[3] = PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.edit.button");
        String[] stringArray2 = stringArray;
        this.fTodoTasksList = new ListDialogField(taskTagAdapter, stringArray2, (ILabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(taskTagAdapter);
        this.fTodoTasksList.setLabelText(PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.label"));
        this.fTodoTasksList.setRemoveButtonIndex(1);
        String[] stringArray3 = new String[]{PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.name.column"), PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.priority.column")};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(stringArray3, true));
        this.unpackTodoTasks();
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(3, false);
        }
        this.fTaskTagsStatus = new StatusInfo();
    }

    protected final String[] getAllKeys() {
        return new String[]{PREF_TRANSLATION_TASK_TAGS, PREF_TRANSLATION_TASK_PRIORITIES};
    }

    protected Control createContents(Composite composite) {
        this.fPixelConverter = new PixelConverter((Control)composite);
        this.setShell(composite.getShell());
        Composite composite2 = this.createMarkersTabContent(composite);
        this.validateSettings(null, null);
        return composite2;
    }

    private Composite createMarkersTabContent(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        this.fTodoTasksList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fTodoTasksList.getLabelControl(null), 2);
        Table table = this.fTodoTasksList.getTableViewer().getTable();
        GridData gridData = (GridData)this.fTodoTasksList.getListControl(null).getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0;
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 6);
        return composite2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(String string, String string2) {
        if (string != null) {
            if (!PREF_TRANSLATION_TASK_TAGS.equals(string)) return;
            this.fTaskTagsStatus = this.validateTaskTags();
        } else {
            this.fTaskTagsStatus = this.validateTaskTags();
        }
        IStatus iStatus = this.fTaskTagsStatus;
        this.fContext.statusChanged(iStatus);
    }

    private IStatus validateTaskTags() {
        return new StatusInfo();
    }

    public boolean performOk(boolean bl) {
        this.packTodoTasks();
        return super.performOk(bl);
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        String string = PreferencesMessages.getString("TodoTaskConfigurationBlock.needsbuild.title");
        String string2 = this.fProject == null ? PreferencesMessages.getString("TodoTaskConfigurationBlock.needsfullbuild.message") : PreferencesMessages.getString("TodoTaskConfigurationBlock.needsprojectbuild.message");
        return new String[]{string, string2};
    }

    protected String[] getFullReParseDialogStrings(boolean bl) {
        String string = PreferencesMessages.getString("TodoTaskConfigurationBlock.needsparse.title");
        String string2 = this.fProject == null ? PreferencesMessages.getString("TodoTaskConfigurationBlock.needsfullparse.message") : PreferencesMessages.getString("TodoTaskConfigurationBlock.needsprojectparse.message");
        return new String[]{string, string2};
    }

    protected void updateControls() {
        this.unpackTodoTasks();
    }

    private void unpackTodoTasks() {
        String string = (String)this.fWorkingValues.get(PREF_TRANSLATION_TASK_TAGS);
        String string2 = (String)this.fWorkingValues.get(PREF_TRANSLATION_TASK_PRIORITIES);
        String[] stringArray = this.getTokens(string, ",");
        String[] stringArray2 = this.getTokens(string2, ",");
        ArrayList<TodoTask> arrayList = new ArrayList<TodoTask>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            TodoTask todoTask = new TodoTask();
            todoTask.name = stringArray[n].trim();
            todoTask.priority = n < stringArray2.length ? stringArray2[n] : PRIORITY_NORMAL;
            arrayList.add(todoTask);
            ++n;
        }
        this.fTodoTasksList.setElements(arrayList);
    }

    private void packTodoTasks() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        List list = this.fTodoTasksList.getElements();
        int n = 0;
        while (n < list.size()) {
            if (n > 0) {
                stringBuffer.append(',');
                stringBuffer2.append(',');
            }
            TodoTask todoTask = (TodoTask)list.get(n);
            stringBuffer.append(todoTask.name);
            stringBuffer2.append(todoTask.priority);
            ++n;
        }
        this.fWorkingValues.put(PREF_TRANSLATION_TASK_TAGS, stringBuffer.toString());
        this.fWorkingValues.put(PREF_TRANSLATION_TASK_PRIORITIES, stringBuffer2.toString());
    }

    private void doTodoButtonPressed(int n) {
        TodoTaskInputDialog todoTaskInputDialog;
        TodoTask todoTask = null;
        if (n != 0) {
            todoTask = (TodoTask)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((todoTaskInputDialog = new TodoTaskInputDialog(this.getShell(), todoTask, this.fTodoTasksList.getElements())).open() == 0) {
            if (todoTask != null) {
                this.fTodoTasksList.replaceElement(todoTask, todoTaskInputDialog.getResult());
            } else {
                this.fTodoTasksList.addElement(todoTaskInputDialog.getResult());
            }
        }
    }

    public static class TodoTask {
        public String name;
        public String priority;
    }

    private static class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TodoTaskLabelProvider() {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            return this.getColumnText(object, 0);
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            TodoTask todoTask = (TodoTask)object;
            if (n == 0) {
                return todoTask.name;
            }
            if (TodoTaskConfigurationBlock.PRIORITY_HIGH.equals(todoTask.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.high.priority");
            }
            if (TodoTaskConfigurationBlock.PRIORITY_NORMAL.equals(todoTask.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.normal.priority");
            }
            if (TodoTaskConfigurationBlock.PRIORITY_LOW.equals(todoTask.priority)) {
                return PreferencesMessages.getString("TodoTaskConfigurationBlock.markers.tasks.low.priority");
            }
            return "";
        }
    }

    public class TaskTagAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(ListDialogField listDialogField) {
            return listDialogField.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            TodoTaskConfigurationBlock.this.doTodoButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            listDialogField.enableButton(3, this.canEdit(listDialogField));
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField)) {
                TodoTaskConfigurationBlock.this.doTodoButtonPressed(3);
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
            TodoTaskConfigurationBlock.this.validateSettings(TodoTaskConfigurationBlock.PREF_TRANSLATION_TASK_TAGS, null);
        }
    }
}

