/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_FULLY_QUALIFIED = 128;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int D_QUALIFIED = 65536;
    public static final int D_POST_QUALIFIED = 131072;
    public static final int CF_QUALIFIED = 262144;
    public static final int CF_POST_QUALIFIED = 524288;
    public static final int CU_QUALIFIED = 0x100000;
    public static final int CU_POST_QUALIFIED = 0x200000;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final int ALL_FULLY_QUALIFIED = 39135392;
    public static final int ALL_POST_QUALIFIED = 78287168;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1386656;
    public static final int DEFAULT_POST_QUALIFIED = 2789696;
    public static final String CONCAT_STRING = CSearchMessages.getString("CElementLabels.concat_string");
    public static final String COMMA_STRING = CSearchMessages.getString("CElementLabels.comma_string");
    public static final String DECL_STRING = CSearchMessages.getString("CElementLabels.declseparator_string");
    static /* synthetic */ Class class$0;

    public static String getTextLabel(Object object, int n) {
        if (object instanceof ICElement) {
            return CElementLabels.getElementLabel((ICElement)object, n);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        }
        return "";
    }

    public static String getElementLabel(ICElement iCElement, int n) {
        StringBuffer stringBuffer = new StringBuffer(60);
        CElementLabels.getElementLabel(iCElement, n, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getElementLabel(ICElement iCElement, int n, StringBuffer stringBuffer) {
        int n2 = iCElement.getElementType();
        switch (n2) {
            case 67: {
                CElementLabels.getMethodLabel((IMethod)iCElement, n, stringBuffer);
            }
        }
    }

    public static void getMethodLabel(IMethod iMethod, int n, StringBuffer stringBuffer) {
        String[] stringArray;
        if (CElementLabels.getFlag(n, 16) && iMethod.exists() && !iMethod.isConstructor()) {
            stringBuffer.append(iMethod.getReturnType());
            stringBuffer.append(' ');
        }
        if (CElementLabels.getFlag(n, 32)) {
            CElementLabels.getTypeLabel(iMethod.getParent(), 0x2000 | n & 0x20000000, stringBuffer);
            stringBuffer.append("::");
        }
        stringBuffer.append(iMethod.getElementName());
        if (CElementLabels.getFlag(n, 3)) {
            stringBuffer.append('(');
            stringArray = CElementLabels.getFlag(n, 1) ? iMethod.getParameterTypes() : null;
            String[] stringArray2 = null;
            int n2 = stringArray != null ? stringArray.length : stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    stringBuffer.append(COMMA_STRING);
                }
                if (stringArray != null) {
                    stringBuffer.append(stringArray[n3]);
                }
                if (stringArray2 != null) {
                    if (stringArray != null) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(stringArray2[n3]);
                }
                ++n3;
            }
            stringBuffer.append(')');
        }
        if (CElementLabels.getFlag(n, 4) && iMethod.exists() && (stringArray = iMethod.getExceptions()).length > 0) {
            stringBuffer.append(" throw( ");
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (n4 > 0) {
                    stringBuffer.append(COMMA_STRING);
                }
                stringBuffer.append(stringArray[n4]);
                ++n4;
            }
            stringBuffer.append(" )");
        }
        if (CElementLabels.getFlag(n, 8) && iMethod.exists() && !iMethod.isConstructor()) {
            stringBuffer.append(DECL_STRING);
            stringBuffer.append(iMethod.getReturnType());
        }
        if (CElementLabels.getFlag(n, 64)) {
            stringBuffer.append(CONCAT_STRING);
            CElementLabels.getTypeLabel(iMethod.getParent(), 0x2000 | n & 0x20000000, stringBuffer);
        }
    }

    public static void getTypeLabel(ICElement iCElement, int n, StringBuffer stringBuffer) {
        if (!(iCElement instanceof IStructure)) {
            return;
        }
    }

    private static boolean getFlag(int n, int n2) {
        return (n & n2) != 0;
    }
}

