/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchOperation;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public FindAction(CEditor cEditor) {
        this.fEditor = cEditor;
        this.fSite = cEditor.getSite();
    }

    public FindAction(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
    }

    protected IParser setupParser(IFile iFile) {
        IScannerInfo iScannerInfo;
        IProject iProject = iFile.getProject();
        ScannerInfo scannerInfo = new ScannerInfo();
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iProject)) != null) {
            scannerInfo = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
        }
        iScannerInfo = CoreModel.getDefault().hasCCNature(iProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser iParser = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(iFile.getLocation().toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((Reader)fileReader, (String)iFile.getLocation().toOSString(), (IScannerInfo)scannerInfo, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)iScannerInfo, (ISourceElementRequestor)new NullSourceElementRequestor(), (IParserLogService)ParserUtil.getScannerLogService()), (ISourceElementRequestor)new NullSourceElementRequestor(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)iScannerInfo, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        return iParser;
    }

    protected CSearchOperation createSearchOperation(String string, ICSearchConstants.SearchFor searchFor) {
        CSearchOperation cSearchOperation = null;
        ICSearchScope iCSearchScope = this.getScope();
        String string2 = this.getScopeDescription();
        LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
        linkedList.add(searchFor);
        CSearchResultCollector cSearchResultCollector = new CSearchResultCollector();
        ICSearchConstants.LimitTo limitTo = this.getLimitTo();
        cSearchOperation = new CSearchOperation(CCorePlugin.getWorkspace(), string, true, linkedList, limitTo, iCSearchScope, string2, cSearchResultCollector);
        return cSearchOperation;
    }

    protected ISelection getSelection() {
        ISelection iSelection = null;
        if (this.fSite != null) {
            iSelection = this.fSite.getSelectionProvider().getSelection();
        }
        return iSelection;
    }

    public void run() {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)iSelection);
        } else if (iSelection instanceof ITextSelection) {
            this.run((ITextSelection)iSelection);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart = this.fSite.getPage().getActiveEditor();
        CEditor cEditor = null;
        if (iEditorPart instanceof CEditor) {
            cEditor = (CEditor)iEditorPart;
        }
        if (cEditor == null || cEditor.getSelectionProvider() == null) {
            this.operationNotAvailableDialog();
            return;
        }
        this.fEditor = cEditor;
        ITextSelection iTextSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        this.run(iTextSelection);
    }

    public void run(ITextSelection iTextSelection) {
        IASTNode iASTNode;
        ITextSelection iTextSelection2;
        block6: {
            if (iTextSelection == null) {
                return;
            }
            iTextSelection2 = iTextSelection;
            int n = iTextSelection2.getOffset();
            int n2 = n + iTextSelection2.getLength();
            IFile iFile = this.fEditor.getInputFile();
            IParser iParser = this.setupParser(iFile);
            iASTNode = null;
            try {
                iASTNode = iParser.parse(n, n2);
            }
            catch (ParseError parseError) {
            }
            catch (Exception exception) {
            }
            catch (VirtualMachineError virtualMachineError) {
                if (!(virtualMachineError instanceof OutOfMemoryError)) break block6;
                Util.log(null, (String)("Selection Search Out Of Memory error: " + virtualMachineError.getMessage() + " on File: " + iFile.getName()), (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        if (iASTNode == null) {
            this.operationNotAvailableDialog();
            return;
        }
        CSearchOperation cSearchOperation = this.createSearchOperation(iTextSelection2.getText(), this.getSearchForFromNode(iASTNode));
        this.performSearch(cSearchOperation);
    }

    private ICSearchConstants.SearchFor getSearchForFromNode(IASTNode iASTNode) {
        ICSearchConstants.SearchFor searchFor = null;
        if (iASTNode instanceof IASTClassSpecifier) {
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
            if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
                searchFor = ICSearchConstants.CLASS;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
                searchFor = ICSearchConstants.UNION;
            }
        } else if (iASTNode instanceof IASTMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (iASTNode instanceof IASTFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (iASTNode instanceof IASTField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (iASTNode instanceof IASTVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (iASTNode instanceof IASTEnumerationSpecifier) {
            searchFor = ICSearchConstants.ENUM;
        } else if (iASTNode instanceof IASTEnumerator) {
            searchFor = ICSearchConstants.FIELD;
        } else if (iASTNode instanceof IASTNamespaceDefinition) {
            searchFor = ICSearchConstants.NAMESPACE;
        }
        return searchFor;
    }

    protected void performSearch(CSearchOperation cSearchOperation) {
        try {
            SearchUI.activateSearchResultView();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.fSite.getShell());
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)cSearchOperation);
        }
        catch (Exception exception) {
            CUIPlugin.getDefault().log(exception);
        }
    }

    private void operationNotAvailableDialog() {
        MessageDialog.openInformation((Shell)this.fEditor.getSite().getShell(), (String)CSearchMessages.getString("CSearchOperation.operationUnavailable.title"), (String)CSearchMessages.getString("CSearchOperation.operationUnavailable.message"));
    }

    protected abstract String getScopeDescription();

    protected abstract ICSearchScope getScope();

    protected abstract ICSearchConstants.LimitTo getLimitTo();
}

