/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.IColorManagerExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractCScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesStyle;
    private IToken fDefaultToken;

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public AbstractCScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
    }

    public AbstractCScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore, int n) {
        super(n);
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
    }

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int n = this.fPropertyNamesColor.length;
        this.fPropertyNamesStyle = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.fPropertyNamesStyle[n2] = String.valueOf(this.fPropertyNamesColor[n2]) + "_bold";
            this.addToken(this.fPropertyNamesColor[n2], this.fPropertyNamesStyle[n2]);
            ++n2;
        }
        this.initializeRules();
    }

    private void addToken(String string, String string2) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string);
        if (this.fColorManager instanceof IColorManagerExtension) {
            IColorManagerExtension iColorManagerExtension = (IColorManagerExtension)((Object)this.fColorManager);
            iColorManagerExtension.unbindColor(string);
            iColorManagerExtension.bindColor(string, rGB);
        }
        boolean bl = this.fPreferenceStore.getBoolean(string2);
        this.fTokenMap.put(string, new Token((Object)new TextAttribute(this.fColorManager.getColor(string), null, bl ? 1 : 0)));
    }

    protected Token getToken(String string) {
        return (Token)this.fTokenMap.get(string);
    }

    private void initializeRules() {
        List list = this.createRules();
        if (list != null) {
            IRule[] iRuleArray = new IRule[list.size()];
            list.toArray(iRuleArray);
            this.setRules(iRuleArray);
        }
    }

    private int indexOf(String string) {
        if (string != null) {
            int n = this.fPropertyNamesColor.length;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(this.fPropertyNamesColor[n2]) || string.equals(this.fPropertyNamesStyle[n2])) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.indexOf(propertyChangeEvent.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        int n = this.indexOf(string);
        Token token = this.getToken(this.fPropertyNamesColor[n]);
        if (this.fPropertyNamesColor[n].equals(string)) {
            this.adaptToColorChange(token, propertyChangeEvent);
        } else {
            this.adaptToStyleChange(token, propertyChangeEvent);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            Object object2;
            String string = propertyChangeEvent.getProperty();
            if (this.fColorManager instanceof IColorManagerExtension) {
                object2 = (IColorManagerExtension)((Object)this.fColorManager);
                object2.unbindColor(string);
                object2.bindColor(string, rGB);
            }
            if ((object2 = token.getData()) instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(string), textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        Object object;
        boolean bl = false;
        Object object2 = propertyChangeEvent.getNewValue();
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (object2 instanceof String) {
            object = (String)object2;
            if ("true".equals(object)) {
                bl = true;
            } else if ("false".equals(object)) {
                bl = false;
            }
        }
        object = token.getData();
        if (object instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object;
            boolean bl3 = bl2 = textAttribute.getStyle() == 1;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? 1 : 0));
            }
        }
    }

    public IToken nextToken() {
        ((RuleBasedScanner)this).fTokenOffset = ((RuleBasedScanner)this).fOffset;
        ((RuleBasedScanner)this).fColumn = -1;
        int n = 0;
        while (n < ((RuleBasedScanner)this).fRules.length) {
            IToken iToken = ((RuleBasedScanner)this).fRules[n].evaluate((ICharacterScanner)this);
            if (!iToken.isUndefined()) {
                return iToken;
            }
            ++n;
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultToken;
    }

    public void setDefaultReturnToken(IToken iToken) {
        this.fDefaultToken = iToken;
    }
}

