/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ReferenceBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ReferenceBlock";
    private static final String LABEL = "ReferenceBlock.label";
    private static final String DESC = "ReferenceBlock.desc";
    private CheckboxTableViewer referenceProjectsViewer;
    private static final int PROJECT_LIST_MULTIPLIER = 10;

    public ReferenceBlock() {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.prj_obj.gif");
    }

    protected IStructuredContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (!(object instanceof IWorkspace)) {
                    return new Object[0];
                }
                ArrayList<IProject> arrayList = new ArrayList<IProject>(15);
                IProject[] iProjectArray = ((IWorkspace)object).getRoot().getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    if (CoreModel.getDefault().hasCNature(iProjectArray[n]) && (ReferenceBlock.this.getContainer().getProject() == null || !ReferenceBlock.this.getContainer().getProject().equals((Object)iProjectArray[n]))) {
                        arrayList.add(iProjectArray[n]);
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
        };
    }

    protected void initializeValues() {
        if (this.getContainer().getProject() != null) {
            try {
                Object[] objectArray = this.getContainer().getProject().getReferencedProjects();
                this.referenceProjectsViewer.setCheckedElements(objectArray);
            }
            catch (CoreException coreException) {}
        }
    }

    public IProject[] getReferencedProjects() {
        Object[] objectArray = this.referenceProjectsViewer.getCheckedElements();
        IProject[] iProjectArray = new IProject[objectArray.length];
        System.arraycopy(objectArray, 0, iProjectArray, 0, objectArray.length);
        return iProjectArray;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 16384);
        label.setText(CUIPlugin.getResourceString(DESC));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.referenceProjectsViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2176);
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.heightHint = ReferenceBlock.getDefaultFontHeight((Control)this.referenceProjectsViewer.getTable(), 10);
        this.referenceProjectsViewer.getTable().setLayoutData((Object)gridData2);
        this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.referenceProjectsViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.initializeValues();
        this.setControl((Control)composite2);
    }

    private static int getDefaultFontHeight(Control control, int n) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n2 = 10;
        if (fontDataArray.length > 0) {
            n2 = fontDataArray[0].getHeight();
        }
        return n * n2;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject[] iProjectArray = this.getReferencedProjects();
        if (iProjectArray != null) {
            IProject iProject = this.getContainer().getProject();
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            iProgressMonitor.beginTask(CUIMessages.getString("ReferenceBlock.task.ReferenceProjects"), 1);
            try {
                IProjectDescription iProjectDescription = iProject.getDescription();
                iProjectDescription.setReferencedProjects(iProjectArray);
                iProject.setDescription(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    public void performDefaults() {
        this.initializeValues();
    }
}

