/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.io.File;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WorkingDirectoryBlock
extends AbstractLaunchConfigurationTab {
    protected Label fWorkingDirLabel;
    protected Button fLocalDirButton;
    protected Text fWorkingDirText;
    protected Button fWorkingDirBrowseButton;
    protected Button fWorkspaceDirButton;
    protected Text fWorkspaceDirText;
    protected Button fWorkspaceDirBrowseButton;
    protected Button fUseDefaultWorkingDirButton;
    protected static final String EMPTY_STRING = "";
    protected ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        this.setControl((Control)composite2);
        this.fWorkingDirLabel = new Label(composite2, 0);
        this.fWorkingDirLabel.setText("Wor&king directory:");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.fWorkingDirLabel.setLayoutData((Object)gridData);
        this.fUseDefaultWorkingDirButton = new Button(composite2, 32);
        this.fUseDefaultWorkingDirButton.setText("Use de&fault working directory");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.fUseDefaultWorkingDirButton.setLayoutData((Object)gridData);
        this.fUseDefaultWorkingDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            }
        });
        this.fLocalDirButton = this.createRadioButton(composite2, "&Local directory");
        this.fLocalDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingDirectoryBlock.this.handleLocationButtonSelected();
            }
        });
        this.fWorkingDirText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fWorkingDirText.setLayoutData((Object)gridData);
        this.fWorkingDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkingDirBrowseButton = this.createPushButton(composite2, "&Browse", null);
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            }
        });
        this.fWorkspaceDirButton = this.createRadioButton(composite2, "Works&pace");
        this.fWorkspaceDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingDirectoryBlock.this.handleLocationButtonSelected();
            }
        });
        this.fWorkspaceDirText = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fWorkspaceDirText.setLayoutData((Object)gridData);
        this.fWorkspaceDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fWorkspaceDirBrowseButton = this.createPushButton(composite2, "B&rowse...", null);
        this.fWorkspaceDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            }
        });
    }

    public void dispose() {
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage("Select a &working directory for the launch configuration");
        String string = this.fWorkingDirText.getText();
        if (!string.trim().equals(EMPTY_STRING) && ((File)(object = new File(string))).exists()) {
            directoryDialog.setFilterPath(string);
        }
        if ((object = directoryDialog.open()) != null) {
            this.fWorkingDirText.setText((String)object);
        }
    }

    protected void handleWorkspaceDirBrowseButtonSelected() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select a &workspace relative working directory");
        IContainer iContainer = this.getContainer();
        if (iContainer != null) {
            objectArray = iContainer.getFullPath();
            containerSelectionDialog.setInitialSelections(new Object[]{objectArray});
        }
        containerSelectionDialog.showClosedProjects(false);
        containerSelectionDialog.open();
        objectArray = containerSelectionDialog.getResult();
        if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof IPath) {
            IPath iPath = (IPath)objectArray[0];
            String string = iPath.makeRelative().toString();
            this.fWorkspaceDirText.setText(string);
        }
    }

    protected IContainer getContainer() {
        IResource iResource = this.getResource();
        if (iResource instanceof IContainer) {
            return (IContainer)iResource;
        }
        return null;
    }

    protected IResource getResource() {
        Path path = new Path(this.fWorkspaceDirText.getText());
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return iWorkspaceRoot.findMember((IPath)path);
    }

    protected void handleLocationButtonSelected() {
        if (!this.isDefaultWorkingDirectory()) {
            boolean bl = this.isLocalWorkingDirectory();
            this.fWorkingDirText.setEnabled(bl);
            this.fWorkingDirBrowseButton.setEnabled(bl);
            this.fWorkspaceDirText.setEnabled(!bl);
            this.fWorkspaceDirBrowseButton.setEnabled(!bl);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        if (this.isDefaultWorkingDirectory()) {
            this.setDefaultWorkingDir();
            this.fLocalDirButton.setEnabled(false);
            this.fWorkingDirText.setEnabled(false);
            this.fWorkingDirBrowseButton.setEnabled(false);
            this.fWorkspaceDirButton.setEnabled(false);
            this.fWorkspaceDirText.setEnabled(false);
            this.fWorkspaceDirBrowseButton.setEnabled(false);
        } else {
            this.fLocalDirButton.setEnabled(true);
            this.fWorkspaceDirButton.setEnabled(true);
            this.handleLocationButtonSelected();
        }
    }

    protected void setDefaultWorkingDir() {
        ILaunchConfiguration iLaunchConfiguration = this.getLaunchConfiguration();
        if (iLaunchConfiguration != null) {
            ICProject iCProject = null;
            try {
                iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration);
            }
            catch (CoreException coreException) {}
            if (iCProject != null) {
                this.fWorkspaceDirText.setText(iCProject.getPath().makeRelative().toOSString());
                this.fLocalDirButton.setSelection(false);
                this.fWorkspaceDirButton.setSelection(true);
                return;
            }
        }
        this.fWorkingDirText.setText(System.getProperty("user.dir"));
        this.fLocalDirButton.setSelection(true);
        this.fWorkspaceDirButton.setSelection(false);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.isLocalWorkingDirectory()) {
            String string = this.fWorkingDirText.getText().trim();
            if (string.length() > 0) {
                File file = new File(string);
                if (!file.exists()) {
                    this.setErrorMessage("Working directory does not exist");
                    return false;
                }
                if (!file.isDirectory()) {
                    this.setErrorMessage("Working directory is not a directory_11");
                    return false;
                }
            }
        } else if (this.getContainer() == null) {
            this.setErrorMessage("Specified project or folder does not exist.");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.setLaunchConfiguration(iLaunchConfiguration);
        try {
            String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            this.fWorkspaceDirText.setText(EMPTY_STRING);
            this.fWorkingDirText.setText(EMPTY_STRING);
            if (string == null) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(string);
                if (path.isAbsolute()) {
                    this.fWorkingDirText.setText(string);
                    this.fLocalDirButton.setSelection(true);
                    this.fWorkspaceDirButton.setSelection(false);
                } else {
                    this.fWorkspaceDirText.setText(string);
                    this.fWorkspaceDirButton.setSelection(true);
                    this.fLocalDirButton.setSelection(false);
                }
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException coreException) {
            this.setErrorMessage("Exception occurred reading configuration " + coreException.getStatus().getMessage());
            LaunchUIPlugin.log(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = null;
        if (!this.isDefaultWorkingDirectory()) {
            if (this.isLocalWorkingDirectory()) {
                string = this.getAttributeValueFrom(this.fWorkingDirText);
            } else {
                Path path = new Path(this.fWorkspaceDirText.getText());
                path = path.makeRelative();
                string = path.toString();
            }
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", string);
    }

    protected String getAttributeValueFrom(Text text) {
        String string = text.getText().trim();
        if (string.length() > 0) {
            return string;
        }
        return null;
    }

    public String getName() {
        return "Working Directory";
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.fUseDefaultWorkingDirButton.getSelection();
    }

    protected boolean isLocalWorkingDirectory() {
        return this.fLocalDirButton.getSelection();
    }

    protected void setLaunchConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        this.fLaunchConfiguration = iLaunchConfiguration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

