/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CConventions {
    private static final String scopeResolutionOperator = "::";
    private static final char fgDot = '.';
    private static final char fgColon = ':';

    private static boolean isValidIdentifier(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (!string.equals(string2) || string.indexOf(" ") != -1) {
            return false;
        }
        int n = string.lastIndexOf(scopeResolutionOperator);
        if (n != -1) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray != null) {
            IStatus iStatus = ResourcesPlugin.getWorkspace().validateName(new String(cArray), 1);
            if (!iStatus.isOK()) {
                return false;
            }
            return !CharOperation.contains('$', cArray);
        }
        return false;
    }

    public static IStatus validateClassName(String string) {
        String string2;
        char[] cArray;
        if (string == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nullName"), null);
        }
        String string3 = string.trim();
        if (!string.equals(string3) || string.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nameWithBlanks"), null);
        }
        int n = string.lastIndexOf(scopeResolutionOperator);
        if (n == -1) {
            cArray = string.toCharArray();
        } else {
            string2 = string.substring(0, n).trim();
            IStatus iStatus = CConventions.validateScopeName(string2);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            String string4 = string.substring(n + 1).trim();
            cArray = string4.toCharArray();
        }
        if (cArray != null) {
            string2 = ResourcesPlugin.getWorkspace().validateName(new String(cArray), 1);
            if (!string2.isOK()) {
                return string2;
            }
            if (CharOperation.contains('$', cArray)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.dollarName"), null);
            }
            if (cArray.length > 0 && Character.isLowerCase(cArray[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.lowercaseName"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.invalidName", string), null);
    }

    public static IStatus validateScopeName(String string) {
        if (string == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nullName"), null);
        }
        int n = string.length();
        if (n == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.emptyName"), null);
        }
        if (string.charAt(0) == '.' || string.charAt(n - 1) == '.') {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.dotName"), null);
        }
        if (CharOperation.isWhitespace(string.charAt(0)) || CharOperation.isWhitespace(string.charAt(string.length() - 1))) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nameWithBlanks"), null);
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        StringTokenizer stringTokenizer = new StringTokenizer(string, scopeResolutionOperator);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char[] cArray = (string2 = string2.trim()).toCharArray();
            if (cArray == null) {
                return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", string2), null);
            }
            IStatus iStatus = iWorkspace.validateName(new String(cArray), 2);
            if (!iStatus.isOK()) {
                return iStatus;
            }
            if (bl && cArray.length > 0 && Character.isLowerCase(cArray[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.lowercaseName"), null);
            }
            bl = false;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String string) {
        return CConventions.validateIdentifier(string);
    }

    public static IStatus validateIdentifier(String string) {
        if (CConventions.isValidIdentifier(string)) {
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", string), null);
    }

    public static IStatus validateMethodName(String string) {
        return CConventions.validateIdentifier(string);
    }
}

