/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.BatchOperation;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ContainerEntry;
import org.eclipse.cdt.internal.core.model.IncludeEntry;
import org.eclipse.cdt.internal.core.model.LibraryEntry;
import org.eclipse.cdt.internal.core.model.MacroEntry;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.ProjectEntry;
import org.eclipse.cdt.internal.core.model.SourceEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreModel {
    private static CoreModel cmodel = null;
    private static CModelManager manager = null;
    private static PathEntryManager pathEntryManager = null;
    public static final String CORE_MODEL_ID = "org.eclipse.cdt.core.coremodel";

    public ICElement create(IPath iPath) {
        return manager.create(iPath);
    }

    public ICElement create(IFile iFile) {
        return manager.create(iFile);
    }

    public ICContainer create(IFolder iFolder) {
        return manager.create(iFolder);
    }

    public ICProject create(IProject iProject) {
        return manager.create(iProject);
    }

    public ICElement create(IResource iResource) {
        return manager.create(iResource);
    }

    public ICModel getCModel() {
        return manager.getCModel();
    }

    public boolean isSharedLib(IFile iFile) {
        return manager.isSharedLib(iFile);
    }

    public boolean isObject(IFile iFile) {
        return manager.isObject(iFile);
    }

    public boolean isExecutable(IFile iFile) {
        return manager.isExecutable(iFile);
    }

    public boolean isBinary(IFile iFile) {
        return manager.isBinary(iFile);
    }

    public boolean isArchive(IFile iFile) {
        return manager.isArchive(iFile);
    }

    public boolean isTranslationUnit(IFile iFile) {
        return manager.isTranslationUnit(iFile);
    }

    public boolean isValidTranslationUnitName(String string) {
        return manager.isValidTranslationUnitName(string);
    }

    public String[] getHeaderExtensions() {
        return manager.getHeaderExtensions();
    }

    public String[] getSourceExtensions() {
        return manager.getSourceExtensions();
    }

    public String[] getTranslationUnitExtensions() {
        return manager.getTranslationUnitExtensions();
    }

    public boolean hasCNature(IProject iProject) {
        return manager.hasCNature(iProject);
    }

    public boolean hasCCNature(IProject iProject) {
        return manager.hasCCNature(iProject);
    }

    public static IProjectEntry newProjectEntry(IPath iPath) {
        return CoreModel.newProjectEntry(iPath, false);
    }

    public static IProjectEntry newProjectEntry(IPath iPath, boolean bl) {
        return new ProjectEntry(iPath, bl);
    }

    public static IContainerEntry newContainerEntry(IPath iPath) {
        return CoreModel.newContainerEntry(iPath, false);
    }

    public static IContainerEntry newContainerEntry(IPath iPath, boolean bl) {
        return new ContainerEntry(iPath, bl);
    }

    public static ILibraryEntry newLibraryEntry(IPath iPath, IPath iPath2, IPath iPath3, IPath iPath4) {
        return CoreModel.newLibraryEntry(iPath, iPath2, iPath3, iPath4, false);
    }

    public static ILibraryEntry newLibraryEntry(IPath iPath, IPath iPath2, IPath iPath3, IPath iPath4, boolean bl) {
        return new LibraryEntry(iPath, iPath2, iPath3, iPath4, bl);
    }

    public static ISourceEntry newSourceEntry(IPath iPath) {
        return CoreModel.newSourceEntry(iPath, APathEntry.NO_EXCLUSION_PATTERNS);
    }

    public static ISourceEntry newSourceEntry(IPath iPath, IPath[] iPathArray) {
        return CoreModel.newSourceEntry(iPath, null, iPathArray);
    }

    public static ISourceEntry newSourceEntry(IPath iPath, IPath iPath2, IPath[] iPathArray) {
        return CoreModel.newSourceEntry(iPath, iPath2, true, iPathArray);
    }

    public static ISourceEntry newSourceEntry(IPath iPath, IPath iPath2, boolean bl, IPath[] iPathArray) {
        return new SourceEntry(iPath, iPath2, bl, iPathArray);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2) {
        return CoreModel.newIncludeEntry(iPath, iPath2, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath) {
        return CoreModel.newIncludeEntry(null, iPath, false);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, boolean bl) {
        return CoreModel.newIncludeEntry(iPath, iPath2, bl, true, APathEntry.NO_EXCLUSION_PATTERNS);
    }

    public static IIncludeEntry newIncludeEntry(IPath iPath, IPath iPath2, boolean bl, boolean bl2, IPath[] iPathArray) {
        return new IncludeEntry(iPath, iPath2, bl, bl2, iPathArray);
    }

    public static IMacroEntry newMacroEntry(IPath iPath, String string, String string2) {
        return CoreModel.newMacroEntry(iPath, string, string2, true, APathEntry.NO_EXCLUSION_PATTERNS, true);
    }

    public static IMacroEntry newMacroEntry(IPath iPath, String string, String string2, boolean bl, IPath[] iPathArray, boolean bl2) {
        return new MacroEntry(iPath, string, string2, bl, iPathArray, bl2);
    }

    public IPathEntryContainer getPathEntryContainer(IPath iPath, ICProject iCProject) throws CModelException {
        return pathEntryManager.getPathEntryContainer(iPath, iCProject);
    }

    public void setPathEntryContainer(ICProject[] iCProjectArray, IPathEntryContainer iPathEntryContainer, IProgressMonitor iProgressMonitor) throws CModelException {
        pathEntryManager.setPathEntryContainer(iCProjectArray, iPathEntryContainer, iProgressMonitor);
    }

    public void setRawPathEntries(ICProject iCProject, IPathEntry[] iPathEntryArray, IProgressMonitor iProgressMonitor) throws CModelException {
        pathEntryManager.setRawPathEntries(iCProject, iPathEntryArray, iProgressMonitor);
    }

    public IPathEntry[] getRawPathEntries(ICProject iCProject) throws CModelException {
        return pathEntryManager.getRawPathEntries(iCProject);
    }

    public IPathEntry[] getResolvedClasspathEntries(ICProject iCProject) throws CModelException {
        return pathEntryManager.getResolvedPathEntries(iCProject);
    }

    public static PathEntryContainerInitializer getPathEntryContainerInitializer(String string) {
        return pathEntryManager.getPathEntryContainerInitializer(string);
    }

    public void resetBinaryParser(IProject iProject) {
        manager.resetBinaryParser(iProject);
    }

    public static CoreModel getDefault() {
        if (cmodel == null) {
            cmodel = new CoreModel();
            manager = CModelManager.getDefault();
            pathEntryManager = PathEntryManager.getDefault();
        }
        return cmodel;
    }

    public void addElementChangedListener(IElementChangedListener iElementChangedListener) {
        manager.addElementChangedListener(iElementChangedListener);
    }

    public void removeElementChangedListener(IElementChangedListener iElementChangedListener) {
        manager.removeElementChangedListener(iElementChangedListener);
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    private CoreModel() {
    }

    public static void run(IWorkspaceRunnable iWorkspaceRunnable, IProgressMonitor iProgressMonitor) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace.isTreeLocked()) {
            new BatchOperation(iWorkspaceRunnable).run(iProgressMonitor);
        } else {
            iWorkspace.run((IWorkspaceRunnable)new BatchOperation(iWorkspaceRunnable), iProgressMonitor);
        }
    }

    public void startIndexing() {
        manager.getIndexManager().reset();
    }

    public IndexManager getIndexManager() {
        return manager.getIndexManager();
    }
}

