/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CDescriptorManager
implements IResourceChangeListener {
    private static HashMap fDescriptorMap;

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (fDescriptorMap == null) {
            return;
        }
        IResource iResource = iResourceChangeEvent.getResource();
        int n = iResourceChangeEvent.getType();
        switch (n) {
            case 4: {
                if (iResource.getType() != 4) break;
                fDescriptorMap.remove(iResource);
                break;
            }
            case 1: {
                IFile iFile;
                IResource iResource2;
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta == null || !((iResource2 = iResourceDelta.getResource()) instanceof IFile) || (iFile = (IFile)iResource2) == null || !iFile.getName().endsWith(".cdtproject") || iFile.exists() || fDescriptorMap == null) break;
                fDescriptorMap.remove(iResource);
            }
        }
    }

    public synchronized ICDescriptor getDescriptor(IProject iProject) throws CoreException {
        CDescriptor cDescriptor;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if ((cDescriptor = (CDescriptor)fDescriptorMap.get(iProject)) == null) {
            cDescriptor = new CDescriptor(iProject);
            cDescriptor.setAutoSave(true);
            fDescriptorMap.put(iProject, cDescriptor);
        }
        return cDescriptor;
    }

    public synchronized void configure(IProject iProject, String string) throws CoreException {
        CDescriptor cDescriptor;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if (fDescriptorMap.get(iProject) != null) {
            Status status = new Status(4, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptorManager.exception.alreadyConfigured"), null);
            throw new CoreException((IStatus)status);
        }
        try {
            cDescriptor = new CDescriptor(iProject, string);
        }
        catch (CoreException coreException) {
            IStatus iStatus = coreException.getStatus();
            if (iStatus.getCode() == 1) {
                CDescriptor cDescriptor2 = new CDescriptor(iProject);
                fDescriptorMap.put(iProject, cDescriptor2);
                return;
            }
            throw coreException;
        }
        cDescriptor.getOwner().configure(iProject, cDescriptor);
        cDescriptor.saveInfo();
        cDescriptor.setAutoSave(true);
        fDescriptorMap.put(iProject, cDescriptor);
    }

    public synchronized void convert(IProject iProject, String string) throws CoreException {
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        CDescriptor cDescriptor = new CDescriptor(iProject, new COwner(string));
        cDescriptor.getOwner().configure(iProject, cDescriptor);
        cDescriptor.saveInfo();
        cDescriptor.setAutoSave(true);
        fDescriptorMap.put(iProject, cDescriptor);
    }
}

