/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.impl.PropertyDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class IFileDocument
extends PropertyDocument {
    protected IFile file;
    protected char[] charContents;
    protected byte[] byteContents;

    public IFileDocument(IFile iFile) {
        this(iFile, (char[])null);
    }

    public IFileDocument(IFile iFile, byte[] byArray) {
        this.file = iFile;
        this.byteContents = byArray;
    }

    public IFileDocument(IFile iFile, char[] cArray) {
        this.file = iFile;
        this.charContents = cArray;
    }

    public byte[] getByteContent() throws IOException {
        if (this.byteContents != null) {
            return this.byteContents;
        }
        IPath iPath = this.file.getLocation();
        if (iPath == null) {
            return new byte[0];
        }
        this.byteContents = Util.getFileByteContent(iPath.toFile());
        return this.byteContents;
    }

    public char[] getCharContent() throws IOException {
        if (this.charContents != null) {
            return this.charContents;
        }
        IPath iPath = this.file.getLocation();
        if (iPath == null) {
            return CharOperation.NO_CHAR;
        }
        this.charContents = Util.getFileCharContent(iPath.toFile(), this.getEncoding());
        return this.charContents;
    }

    public String getEncoding() {
        return null;
    }

    public String getName() {
        return this.file.getFullPath().toString();
    }

    public String getStringContent() throws IOException {
        return new String(this.getCharContent());
    }

    public String getType() {
        String string = this.file.getFileExtension();
        if (string == null) {
            return "";
        }
        return string;
    }
}

